package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDomainClaimBuilder extends ClusterDomainClaimFluent<ClusterDomainClaimBuilder> implements VisitableBuilder<ClusterDomainClaim,ClusterDomainClaimBuilder>{
  public ClusterDomainClaimBuilder() {
    this(false);
  }
  public ClusterDomainClaimBuilder(Boolean validationEnabled) {
    this(new ClusterDomainClaim(), validationEnabled);
  }
  public ClusterDomainClaimBuilder(ClusterDomainClaimFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDomainClaimBuilder(ClusterDomainClaimFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDomainClaim(), validationEnabled);
  }
  public ClusterDomainClaimBuilder(ClusterDomainClaimFluent<?> fluent,ClusterDomainClaim instance) {
    this(fluent, instance, false);
  }
  public ClusterDomainClaimBuilder(ClusterDomainClaimFluent<?> fluent,ClusterDomainClaim instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterDomainClaim());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterDomainClaimBuilder(ClusterDomainClaim instance) {
    this(instance,false);
  }
  public ClusterDomainClaimBuilder(ClusterDomainClaim instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterDomainClaim());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterDomainClaimFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDomainClaim build() {
    ClusterDomainClaim buildable = new ClusterDomainClaim(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    return buildable;
  }
  
}