package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDomainClaimSpecBuilder extends ClusterDomainClaimSpecFluent<ClusterDomainClaimSpecBuilder> implements VisitableBuilder<ClusterDomainClaimSpec,ClusterDomainClaimSpecBuilder>{
  public ClusterDomainClaimSpecBuilder() {
    this(false);
  }
  public ClusterDomainClaimSpecBuilder(Boolean validationEnabled) {
    this(new ClusterDomainClaimSpec(), validationEnabled);
  }
  public ClusterDomainClaimSpecBuilder(ClusterDomainClaimSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDomainClaimSpecBuilder(ClusterDomainClaimSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDomainClaimSpec(), validationEnabled);
  }
  public ClusterDomainClaimSpecBuilder(ClusterDomainClaimSpecFluent<?> fluent,ClusterDomainClaimSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterDomainClaimSpecBuilder(ClusterDomainClaimSpecFluent<?> fluent,ClusterDomainClaimSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterDomainClaimSpec());

    if (instance != null) {
      fluent.withNamespace(instance.getNamespace());
      fluent.withNamespace(instance.getNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterDomainClaimSpecBuilder(ClusterDomainClaimSpec instance) {
    this(instance,false);
  }
  public ClusterDomainClaimSpecBuilder(ClusterDomainClaimSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterDomainClaimSpec());

    if (instance != null) {
      this.withNamespace(instance.getNamespace());
      this.withNamespace(instance.getNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterDomainClaimSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDomainClaimSpec build() {
    ClusterDomainClaimSpec buildable = new ClusterDomainClaimSpec(fluent.getNamespace());
    return buildable;
  }
  
}