package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPIngressPathBuilder extends HTTPIngressPathFluent<HTTPIngressPathBuilder> implements VisitableBuilder<HTTPIngressPath,HTTPIngressPathBuilder>{
  public HTTPIngressPathBuilder() {
    this(false);
  }
  public HTTPIngressPathBuilder(Boolean validationEnabled) {
    this(new HTTPIngressPath(), validationEnabled);
  }
  public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPIngressPath(), validationEnabled);
  }
  public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent,HTTPIngressPath instance) {
    this(fluent, instance, false);
  }
  public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent,HTTPIngressPath instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPIngressPath());

    if (instance != null) {
      fluent.withAppendHeaders(instance.getAppendHeaders());
      fluent.withHeaders(instance.getHeaders());
      fluent.withPath(instance.getPath());
      fluent.withRewriteHost(instance.getRewriteHost());
      fluent.withSplits(instance.getSplits());
      fluent.withAppendHeaders(instance.getAppendHeaders());
      fluent.withHeaders(instance.getHeaders());
      fluent.withPath(instance.getPath());
      fluent.withRewriteHost(instance.getRewriteHost());
      fluent.withSplits(instance.getSplits());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPIngressPathBuilder(HTTPIngressPath instance) {
    this(instance,false);
  }
  public HTTPIngressPathBuilder(HTTPIngressPath instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPIngressPath());

    if (instance != null) {
      this.withAppendHeaders(instance.getAppendHeaders());
      this.withHeaders(instance.getHeaders());
      this.withPath(instance.getPath());
      this.withRewriteHost(instance.getRewriteHost());
      this.withSplits(instance.getSplits());
      this.withAppendHeaders(instance.getAppendHeaders());
      this.withHeaders(instance.getHeaders());
      this.withPath(instance.getPath());
      this.withRewriteHost(instance.getRewriteHost());
      this.withSplits(instance.getSplits());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPIngressPathFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPIngressPath build() {
    HTTPIngressPath buildable = new HTTPIngressPath(fluent.getAppendHeaders(),fluent.getHeaders(),fluent.getPath(),fluent.getRewriteHost(),fluent.buildSplits());
    return buildable;
  }
  
}