package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressBackendSplitBuilder extends IngressBackendSplitFluent<IngressBackendSplitBuilder> implements VisitableBuilder<IngressBackendSplit,IngressBackendSplitBuilder>{
  public IngressBackendSplitBuilder() {
    this(false);
  }
  public IngressBackendSplitBuilder(Boolean validationEnabled) {
    this(new IngressBackendSplit(), validationEnabled);
  }
  public IngressBackendSplitBuilder(IngressBackendSplitFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressBackendSplitBuilder(IngressBackendSplitFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressBackendSplit(), validationEnabled);
  }
  public IngressBackendSplitBuilder(IngressBackendSplitFluent<?> fluent,IngressBackendSplit instance) {
    this(fluent, instance, false);
  }
  public IngressBackendSplitBuilder(IngressBackendSplitFluent<?> fluent,IngressBackendSplit instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressBackendSplit());

    if (instance != null) {
      fluent.withAppendHeaders(instance.getAppendHeaders());
      fluent.withPercent(instance.getPercent());
      fluent.withServiceName(instance.getServiceName());
      fluent.withServiceNamespace(instance.getServiceNamespace());
      fluent.withServicePort(instance.getServicePort());
      fluent.withAppendHeaders(instance.getAppendHeaders());
      fluent.withPercent(instance.getPercent());
      fluent.withServiceName(instance.getServiceName());
      fluent.withServiceNamespace(instance.getServiceNamespace());
      fluent.withServicePort(instance.getServicePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressBackendSplitBuilder(IngressBackendSplit instance) {
    this(instance,false);
  }
  public IngressBackendSplitBuilder(IngressBackendSplit instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressBackendSplit());

    if (instance != null) {
      this.withAppendHeaders(instance.getAppendHeaders());
      this.withPercent(instance.getPercent());
      this.withServiceName(instance.getServiceName());
      this.withServiceNamespace(instance.getServiceNamespace());
      this.withServicePort(instance.getServicePort());
      this.withAppendHeaders(instance.getAppendHeaders());
      this.withPercent(instance.getPercent());
      this.withServiceName(instance.getServiceName());
      this.withServiceNamespace(instance.getServiceNamespace());
      this.withServicePort(instance.getServicePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressBackendSplitFluent<?> fluent;
  Boolean validationEnabled;
  public IngressBackendSplit build() {
    IngressBackendSplit buildable = new IngressBackendSplit(fluent.getAppendHeaders(),fluent.getPercent(),fluent.getServiceName(),fluent.getServiceNamespace(),fluent.buildServicePort());
    return buildable;
  }
  
}