package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerIngressStatusBuilder extends LoadBalancerIngressStatusFluent<LoadBalancerIngressStatusBuilder> implements VisitableBuilder<LoadBalancerIngressStatus,LoadBalancerIngressStatusBuilder>{
  public LoadBalancerIngressStatusBuilder() {
    this(false);
  }
  public LoadBalancerIngressStatusBuilder(Boolean validationEnabled) {
    this(new LoadBalancerIngressStatus(), validationEnabled);
  }
  public LoadBalancerIngressStatusBuilder(LoadBalancerIngressStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerIngressStatusBuilder(LoadBalancerIngressStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LoadBalancerIngressStatus(), validationEnabled);
  }
  public LoadBalancerIngressStatusBuilder(LoadBalancerIngressStatusFluent<?> fluent,LoadBalancerIngressStatus instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerIngressStatusBuilder(LoadBalancerIngressStatusFluent<?> fluent,LoadBalancerIngressStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LoadBalancerIngressStatus());

    if (instance != null) {
      fluent.withDomain(instance.getDomain());
      fluent.withDomainInternal(instance.getDomainInternal());
      fluent.withIp(instance.getIp());
      fluent.withMeshOnly(instance.getMeshOnly());
      fluent.withDomain(instance.getDomain());
      fluent.withDomainInternal(instance.getDomainInternal());
      fluent.withIp(instance.getIp());
      fluent.withMeshOnly(instance.getMeshOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerIngressStatusBuilder(LoadBalancerIngressStatus instance) {
    this(instance,false);
  }
  public LoadBalancerIngressStatusBuilder(LoadBalancerIngressStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LoadBalancerIngressStatus());

    if (instance != null) {
      this.withDomain(instance.getDomain());
      this.withDomainInternal(instance.getDomainInternal());
      this.withIp(instance.getIp());
      this.withMeshOnly(instance.getMeshOnly());
      this.withDomain(instance.getDomain());
      this.withDomainInternal(instance.getDomainInternal());
      this.withIp(instance.getIp());
      this.withMeshOnly(instance.getMeshOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  LoadBalancerIngressStatusFluent<?> fluent;
  Boolean validationEnabled;
  public LoadBalancerIngressStatus build() {
    LoadBalancerIngressStatus buildable = new LoadBalancerIngressStatus(fluent.getDomain(),fluent.getDomainInternal(),fluent.getIp(),fluent.getMeshOnly());
    return buildable;
  }
  
}