package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServerlessServiceBuilder extends ServerlessServiceFluent<ServerlessServiceBuilder> implements VisitableBuilder<ServerlessService,ServerlessServiceBuilder>{
  public ServerlessServiceBuilder() {
    this(false);
  }
  public ServerlessServiceBuilder(Boolean validationEnabled) {
    this(new ServerlessService(), validationEnabled);
  }
  public ServerlessServiceBuilder(ServerlessServiceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServerlessServiceBuilder(ServerlessServiceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServerlessService(), validationEnabled);
  }
  public ServerlessServiceBuilder(ServerlessServiceFluent<?> fluent,ServerlessService instance) {
    this(fluent, instance, false);
  }
  public ServerlessServiceBuilder(ServerlessServiceFluent<?> fluent,ServerlessService instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServerlessService());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServerlessServiceBuilder(ServerlessService instance) {
    this(instance,false);
  }
  public ServerlessServiceBuilder(ServerlessService instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServerlessService());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServerlessServiceFluent<?> fluent;
  Boolean validationEnabled;
  public ServerlessService build() {
    ServerlessService buildable = new ServerlessService(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}