package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AddressableTypeBuilder extends AddressableTypeFluent<AddressableTypeBuilder> implements VisitableBuilder<AddressableType,AddressableTypeBuilder>{
  public AddressableTypeBuilder() {
    this(false);
  }
  public AddressableTypeBuilder(Boolean validationEnabled) {
    this(new AddressableType(), validationEnabled);
  }
  public AddressableTypeBuilder(AddressableTypeFluent<?> fluent) {
    this(fluent, false);
  }
  public AddressableTypeBuilder(AddressableTypeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AddressableType(), validationEnabled);
  }
  public AddressableTypeBuilder(AddressableTypeFluent<?> fluent,AddressableType instance) {
    this(fluent, instance, false);
  }
  public AddressableTypeBuilder(AddressableTypeFluent<?> fluent,AddressableType instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AddressableType());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AddressableTypeBuilder(AddressableType instance) {
    this(instance,false);
  }
  public AddressableTypeBuilder(AddressableType instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AddressableType());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  AddressableTypeFluent<?> fluent;
  Boolean validationEnabled;
  public AddressableType build() {
    AddressableType buildable = new AddressableType(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildStatus());
    return buildable;
  }
  
}