package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CronJobBuilder extends CronJobFluent<CronJobBuilder> implements VisitableBuilder<CronJob,CronJobBuilder>{
  public CronJobBuilder() {
    this(false);
  }
  public CronJobBuilder(Boolean validationEnabled) {
    this(new CronJob(), validationEnabled);
  }
  public CronJobBuilder(CronJobFluent<?> fluent) {
    this(fluent, false);
  }
  public CronJobBuilder(CronJobFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CronJob(), validationEnabled);
  }
  public CronJobBuilder(CronJobFluent<?> fluent,CronJob instance) {
    this(fluent, instance, false);
  }
  public CronJobBuilder(CronJobFluent<?> fluent,CronJob instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CronJob());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CronJobBuilder(CronJob instance) {
    this(instance,false);
  }
  public CronJobBuilder(CronJob instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CronJob());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  CronJobFluent<?> fluent;
  Boolean validationEnabled;
  public CronJob build() {
    CronJob buildable = new CronJob(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.getSpec());
    return buildable;
  }
  
}