package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KResourceListBuilder extends KResourceListFluent<KResourceListBuilder> implements VisitableBuilder<KResourceList,KResourceListBuilder>{
  public KResourceListBuilder() {
    this(false);
  }
  public KResourceListBuilder(Boolean validationEnabled) {
    this(new KResourceList(), validationEnabled);
  }
  public KResourceListBuilder(KResourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public KResourceListBuilder(KResourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KResourceList(), validationEnabled);
  }
  public KResourceListBuilder(KResourceListFluent<?> fluent,KResourceList instance) {
    this(fluent, instance, false);
  }
  public KResourceListBuilder(KResourceListFluent<?> fluent,KResourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KResourceList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KResourceListBuilder(KResourceList instance) {
    this(instance,false);
  }
  public KResourceListBuilder(KResourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KResourceList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  KResourceListFluent<?> fluent;
  Boolean validationEnabled;
  public KResourceList build() {
    KResourceList buildable = new KResourceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}