package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSpecableBuilder extends PodSpecableFluent<PodSpecableBuilder> implements VisitableBuilder<PodSpecable,PodSpecableBuilder>{
  public PodSpecableBuilder() {
    this(false);
  }
  public PodSpecableBuilder(Boolean validationEnabled) {
    this(new PodSpecable(), validationEnabled);
  }
  public PodSpecableBuilder(PodSpecableFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSpecableBuilder(PodSpecableFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSpecable(), validationEnabled);
  }
  public PodSpecableBuilder(PodSpecableFluent<?> fluent,PodSpecable instance) {
    this(fluent, instance, false);
  }
  public PodSpecableBuilder(PodSpecableFluent<?> fluent,PodSpecable instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSpecable());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSpecableBuilder(PodSpecable instance) {
    this(instance,false);
  }
  public PodSpecableBuilder(PodSpecable instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSpecable());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSpecableFluent<?> fluent;
  Boolean validationEnabled;
  public PodSpecable build() {
    PodSpecable buildable = new PodSpecable(fluent.buildMetadata(),fluent.getSpec());
    return buildable;
  }
  
}