package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceBuilder extends SourceFluent<SourceBuilder> implements VisitableBuilder<Source,SourceBuilder>{
  public SourceBuilder() {
    this(false);
  }
  public SourceBuilder(Boolean validationEnabled) {
    this(new Source(), validationEnabled);
  }
  public SourceBuilder(SourceFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceBuilder(SourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Source(), validationEnabled);
  }
  public SourceBuilder(SourceFluent<?> fluent,Source instance) {
    this(fluent, instance, false);
  }
  public SourceBuilder(SourceFluent<?> fluent,Source instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Source());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourceBuilder(Source instance) {
    this(instance,false);
  }
  public SourceBuilder(Source instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Source());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourceFluent<?> fluent;
  Boolean validationEnabled;
  public Source build() {
    Source buildable = new Source(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}