package io.fabric8.knative.internal.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BindingListBuilder extends BindingListFluent<BindingListBuilder> implements VisitableBuilder<BindingList,BindingListBuilder>{
  public BindingListBuilder() {
    this(false);
  }
  public BindingListBuilder(Boolean validationEnabled) {
    this(new BindingList(), validationEnabled);
  }
  public BindingListBuilder(BindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public BindingListBuilder(BindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BindingList(), validationEnabled);
  }
  public BindingListBuilder(BindingListFluent<?> fluent,BindingList instance) {
    this(fluent, instance, false);
  }
  public BindingListBuilder(BindingListFluent<?> fluent,BindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BindingList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BindingListBuilder(BindingList instance) {
    this(instance,false);
  }
  public BindingListBuilder(BindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BindingList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  BindingListFluent<?> fluent;
  Boolean validationEnabled;
  public BindingList build() {
    BindingList buildable = new BindingList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}