package io.fabric8.knative.internal.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TargetListBuilder extends TargetListFluent<TargetListBuilder> implements VisitableBuilder<TargetList,TargetListBuilder>{
  public TargetListBuilder() {
    this(false);
  }
  public TargetListBuilder(Boolean validationEnabled) {
    this(new TargetList(), validationEnabled);
  }
  public TargetListBuilder(TargetListFluent<?> fluent) {
    this(fluent, false);
  }
  public TargetListBuilder(TargetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TargetList(), validationEnabled);
  }
  public TargetListBuilder(TargetListFluent<?> fluent,TargetList instance) {
    this(fluent, instance, false);
  }
  public TargetListBuilder(TargetListFluent<?> fluent,TargetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TargetList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TargetListBuilder(TargetList instance) {
    this(instance,false);
  }
  public TargetListBuilder(TargetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TargetList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  TargetListFluent<?> fluent;
  Boolean validationEnabled;
  public TargetList build() {
    TargetList buildable = new TargetList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}