package io.fabric8.knative.internal.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TargetableBuilder extends TargetableFluent<TargetableBuilder> implements VisitableBuilder<Targetable,TargetableBuilder>{
  public TargetableBuilder() {
    this(false);
  }
  public TargetableBuilder(Boolean validationEnabled) {
    this(new Targetable(), validationEnabled);
  }
  public TargetableBuilder(TargetableFluent<?> fluent) {
    this(fluent, false);
  }
  public TargetableBuilder(TargetableFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Targetable(), validationEnabled);
  }
  public TargetableBuilder(TargetableFluent<?> fluent,Targetable instance) {
    this(fluent, instance, false);
  }
  public TargetableBuilder(TargetableFluent<?> fluent,Targetable instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Targetable());

    if (instance != null) {
      fluent.withDomainInternal(instance.getDomainInternal());
      fluent.withDomainInternal(instance.getDomainInternal());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TargetableBuilder(Targetable instance) {
    this(instance,false);
  }
  public TargetableBuilder(Targetable instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Targetable());

    if (instance != null) {
      this.withDomainInternal(instance.getDomainInternal());
      this.withDomainInternal(instance.getDomainInternal());
    }
    this.validationEnabled = validationEnabled; 
  }
  TargetableFluent<?> fluent;
  Boolean validationEnabled;
  public Targetable build() {
    Targetable buildable = new Targetable(fluent.getDomainInternal());
    return buildable;
  }
  
}