package io.fabric8.knative.internal.pkg.apis.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AddressStatusBuilder extends AddressStatusFluent<AddressStatusBuilder> implements VisitableBuilder<AddressStatus,AddressStatusBuilder>{
  public AddressStatusBuilder() {
    this(false);
  }
  public AddressStatusBuilder(Boolean validationEnabled) {
    this(new AddressStatus(), validationEnabled);
  }
  public AddressStatusBuilder(AddressStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AddressStatusBuilder(AddressStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AddressStatus(), validationEnabled);
  }
  public AddressStatusBuilder(AddressStatusFluent<?> fluent,AddressStatus instance) {
    this(fluent, instance, false);
  }
  public AddressStatusBuilder(AddressStatusFluent<?> fluent,AddressStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AddressStatus());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AddressStatusBuilder(AddressStatus instance) {
    this(instance,false);
  }
  public AddressStatusBuilder(AddressStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AddressStatus());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
    }
    this.validationEnabled = validationEnabled; 
  }
  AddressStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AddressStatus build() {
    AddressStatus buildable = new AddressStatus(fluent.buildAddress(),fluent.buildAddresses());
    return buildable;
  }
  
}