package io.fabric8.knative.internal.pkg.tracker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReferenceBuilder extends ReferenceFluent<ReferenceBuilder> implements VisitableBuilder<Reference,ReferenceBuilder>{
  public ReferenceBuilder() {
    this(false);
  }
  public ReferenceBuilder(Boolean validationEnabled) {
    this(new Reference(), validationEnabled);
  }
  public ReferenceBuilder(ReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ReferenceBuilder(ReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Reference(), validationEnabled);
  }
  public ReferenceBuilder(ReferenceFluent<?> fluent,Reference instance) {
    this(fluent, instance, false);
  }
  public ReferenceBuilder(ReferenceFluent<?> fluent,Reference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Reference());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withSelector(instance.getSelector());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReferenceBuilder(Reference instance) {
    this(instance,false);
  }
  public ReferenceBuilder(Reference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Reference());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withSelector(instance.getSelector());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public Reference build() {
    Reference buildable = new Reference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.buildSelector());
    return buildable;
  }
  
}