package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChannelStatusBuilder extends ChannelStatusFluent<ChannelStatusBuilder> implements VisitableBuilder<ChannelStatus,ChannelStatusBuilder>{
  public ChannelStatusBuilder() {
    this(false);
  }
  public ChannelStatusBuilder(Boolean validationEnabled) {
    this(new ChannelStatus(), validationEnabled);
  }
  public ChannelStatusBuilder(ChannelStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChannelStatus(), validationEnabled);
  }
  public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,ChannelStatus instance) {
    this(fluent, instance, false);
  }
  public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,ChannelStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ChannelStatus());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withChannel(instance.getChannel());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscribers(instance.getSubscribers());
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withChannel(instance.getChannel());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChannelStatusBuilder(ChannelStatus instance) {
    this(instance,false);
  }
  public ChannelStatusBuilder(ChannelStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ChannelStatus());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
      this.withAnnotations(instance.getAnnotations());
      this.withChannel(instance.getChannel());
      this.withConditions(instance.getConditions());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscribers(instance.getSubscribers());
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
      this.withAnnotations(instance.getAnnotations());
      this.withChannel(instance.getChannel());
      this.withConditions(instance.getConditions());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChannelStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ChannelStatus build() {
    ChannelStatus buildable = new ChannelStatus(fluent.buildAddress(),fluent.buildAddresses(),fluent.getAnnotations(),fluent.buildChannel(),fluent.buildConditions(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration(),fluent.buildSubscribers());
    return buildable;
  }
  
}