package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InMemoryChannelBuilder extends InMemoryChannelFluent<InMemoryChannelBuilder> implements VisitableBuilder<InMemoryChannel,InMemoryChannelBuilder>{
  public InMemoryChannelBuilder() {
    this(false);
  }
  public InMemoryChannelBuilder(Boolean validationEnabled) {
    this(new InMemoryChannel(), validationEnabled);
  }
  public InMemoryChannelBuilder(InMemoryChannelFluent<?> fluent) {
    this(fluent, false);
  }
  public InMemoryChannelBuilder(InMemoryChannelFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InMemoryChannel(), validationEnabled);
  }
  public InMemoryChannelBuilder(InMemoryChannelFluent<?> fluent,InMemoryChannel instance) {
    this(fluent, instance, false);
  }
  public InMemoryChannelBuilder(InMemoryChannelFluent<?> fluent,InMemoryChannel instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new InMemoryChannel());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InMemoryChannelBuilder(InMemoryChannel instance) {
    this(instance,false);
  }
  public InMemoryChannelBuilder(InMemoryChannel instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new InMemoryChannel());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  InMemoryChannelFluent<?> fluent;
  Boolean validationEnabled;
  public InMemoryChannel build() {
    InMemoryChannel buildable = new InMemoryChannel(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}