package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InMemoryChannelSpecBuilder extends InMemoryChannelSpecFluent<InMemoryChannelSpecBuilder> implements VisitableBuilder<InMemoryChannelSpec,InMemoryChannelSpecBuilder>{
  public InMemoryChannelSpecBuilder() {
    this(false);
  }
  public InMemoryChannelSpecBuilder(Boolean validationEnabled) {
    this(new InMemoryChannelSpec(), validationEnabled);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InMemoryChannelSpec(), validationEnabled);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance) {
    this(fluent, instance, false);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new InMemoryChannelSpec());

    if (instance != null) {
      fluent.withDelivery(instance.getDelivery());
      fluent.withSubscribers(instance.getSubscribers());
      fluent.withDelivery(instance.getDelivery());
      fluent.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance) {
    this(instance,false);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new InMemoryChannelSpec());

    if (instance != null) {
      this.withDelivery(instance.getDelivery());
      this.withSubscribers(instance.getSubscribers());
      this.withDelivery(instance.getDelivery());
      this.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  InMemoryChannelSpecFluent<?> fluent;
  Boolean validationEnabled;
  public InMemoryChannelSpec build() {
    InMemoryChannelSpec buildable = new InMemoryChannelSpec(fluent.buildDelivery(),fluent.buildSubscribers());
    return buildable;
  }
  
}