package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InMemoryChannelStatusBuilder extends InMemoryChannelStatusFluent<InMemoryChannelStatusBuilder> implements VisitableBuilder<InMemoryChannelStatus,InMemoryChannelStatusBuilder>{
  public InMemoryChannelStatusBuilder() {
    this(false);
  }
  public InMemoryChannelStatusBuilder(Boolean validationEnabled) {
    this(new InMemoryChannelStatus(), validationEnabled);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InMemoryChannelStatus(), validationEnabled);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,InMemoryChannelStatus instance) {
    this(fluent, instance, false);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,InMemoryChannelStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new InMemoryChannelStatus());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscribers(instance.getSubscribers());
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatus instance) {
    this(instance,false);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new InMemoryChannelStatus());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscribers(instance.getSubscribers());
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  InMemoryChannelStatusFluent<?> fluent;
  Boolean validationEnabled;
  public InMemoryChannelStatus build() {
    InMemoryChannelStatus buildable = new InMemoryChannelStatus(fluent.buildAddress(),fluent.buildAddresses(),fluent.getAnnotations(),fluent.buildConditions(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration(),fluent.buildSubscribers());
    return buildable;
  }
  
}