package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SubscriptionSpecFluent<A extends SubscriptionSpecFluent<A>> extends BaseFluent<A>{
  public SubscriptionSpecFluent() {
  }
  public SubscriptionSpecFluent(SubscriptionSpec instance) {
    instance = (instance != null ? instance : new SubscriptionSpec());

    if (instance != null) {
      this.withChannel(instance.getChannel());
      this.withDelivery(instance.getDelivery());
      this.withReply(instance.getReply());
      this.withSubscriber(instance.getSubscriber());
      this.withChannel(instance.getChannel());
      this.withDelivery(instance.getDelivery());
      this.withReply(instance.getReply());
      this.withSubscriber(instance.getSubscriber());
    }
  }
  private KReferenceBuilder channel;
  private DeliverySpecBuilder delivery;
  private DestinationBuilder reply;
  private DestinationBuilder subscriber;
  public KReference buildChannel() {
    return this.channel!=null ?this.channel.build():null;
  }
  public A withChannel(KReference channel) {
    _visitables.get("channel").remove(this.channel);
    if (channel!=null){ this.channel= new KReferenceBuilder(channel); _visitables.get("channel").add(this.channel);} else { this.channel = null; _visitables.get("channel").remove(this.channel); } return (A) this;
  }
  public boolean hasChannel() {
    return this.channel != null;
  }
  public ChannelNested<A> withNewChannel() {
    return new ChannelNested(null);
  }
  public ChannelNested<A> withNewChannelLike(KReference item) {
    return new ChannelNested(item);
  }
  public ChannelNested<A> editChannel() {
    return withNewChannelLike(java.util.Optional.ofNullable(buildChannel()).orElse(null));
  }
  public ChannelNested<A> editOrNewChannel() {
    return withNewChannelLike(java.util.Optional.ofNullable(buildChannel()).orElse(new KReferenceBuilder().build()));
  }
  public ChannelNested<A> editOrNewChannelLike(KReference item) {
    return withNewChannelLike(java.util.Optional.ofNullable(buildChannel()).orElse(item));
  }
  public DeliverySpec buildDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public A withDelivery(DeliverySpec delivery) {
    _visitables.get("delivery").remove(this.delivery);
    if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} else { this.delivery = null; _visitables.get("delivery").remove(this.delivery); } return (A) this;
  }
  public boolean hasDelivery() {
    return this.delivery != null;
  }
  public DeliveryNested<A> withNewDelivery() {
    return new DeliveryNested(null);
  }
  public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new DeliveryNested(item);
  }
  public DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(null));
  }
  public DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(new DeliverySpecBuilder().build()));
  }
  public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(item));
  }
  public Destination buildReply() {
    return this.reply!=null ?this.reply.build():null;
  }
  public A withReply(Destination reply) {
    _visitables.get("reply").remove(this.reply);
    if (reply!=null){ this.reply= new DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} else { this.reply = null; _visitables.get("reply").remove(this.reply); } return (A) this;
  }
  public boolean hasReply() {
    return this.reply != null;
  }
  public ReplyNested<A> withNewReply() {
    return new ReplyNested(null);
  }
  public ReplyNested<A> withNewReplyLike(Destination item) {
    return new ReplyNested(item);
  }
  public ReplyNested<A> editReply() {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(null));
  }
  public ReplyNested<A> editOrNewReply() {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(new DestinationBuilder().build()));
  }
  public ReplyNested<A> editOrNewReplyLike(Destination item) {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(item));
  }
  public Destination buildSubscriber() {
    return this.subscriber!=null ?this.subscriber.build():null;
  }
  public A withSubscriber(Destination subscriber) {
    _visitables.get("subscriber").remove(this.subscriber);
    if (subscriber!=null){ this.subscriber= new DestinationBuilder(subscriber); _visitables.get("subscriber").add(this.subscriber);} else { this.subscriber = null; _visitables.get("subscriber").remove(this.subscriber); } return (A) this;
  }
  public boolean hasSubscriber() {
    return this.subscriber != null;
  }
  public SubscriberNested<A> withNewSubscriber() {
    return new SubscriberNested(null);
  }
  public SubscriberNested<A> withNewSubscriberLike(Destination item) {
    return new SubscriberNested(item);
  }
  public SubscriberNested<A> editSubscriber() {
    return withNewSubscriberLike(java.util.Optional.ofNullable(buildSubscriber()).orElse(null));
  }
  public SubscriberNested<A> editOrNewSubscriber() {
    return withNewSubscriberLike(java.util.Optional.ofNullable(buildSubscriber()).orElse(new DestinationBuilder().build()));
  }
  public SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
    return withNewSubscriberLike(java.util.Optional.ofNullable(buildSubscriber()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SubscriptionSpecFluent that = (SubscriptionSpecFluent) o;
    if (!java.util.Objects.equals(channel, that.channel)) return false;

    if (!java.util.Objects.equals(delivery, that.delivery)) return false;

    if (!java.util.Objects.equals(reply, that.reply)) return false;

    if (!java.util.Objects.equals(subscriber, that.subscriber)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(channel,  delivery,  reply,  subscriber,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (channel != null) { sb.append("channel:"); sb.append(channel + ","); }
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (reply != null) { sb.append("reply:"); sb.append(reply + ","); }
    if (subscriber != null) { sb.append("subscriber:"); sb.append(subscriber); }
    sb.append("}");
    return sb.toString();
  }
  public class ChannelNested<N> extends KReferenceFluent<ChannelNested<N>> implements Nested<N>{
    ChannelNested(KReference item) {
      this.builder = new KReferenceBuilder(this, item);
    }
    KReferenceBuilder builder;
    public N and() {
      return (N) SubscriptionSpecFluent.this.withChannel(builder.build());
    }
    public N endChannel() {
      return and();
    }
    
  }
  public class DeliveryNested<N> extends DeliverySpecFluent<DeliveryNested<N>> implements Nested<N>{
    DeliveryNested(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliverySpecBuilder builder;
    public N and() {
      return (N) SubscriptionSpecFluent.this.withDelivery(builder.build());
    }
    public N endDelivery() {
      return and();
    }
    
  }
  public class ReplyNested<N> extends DestinationFluent<ReplyNested<N>> implements Nested<N>{
    ReplyNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) SubscriptionSpecFluent.this.withReply(builder.build());
    }
    public N endReply() {
      return and();
    }
    
  }
  public class SubscriberNested<N> extends DestinationFluent<SubscriberNested<N>> implements Nested<N>{
    SubscriberNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) SubscriptionSpecFluent.this.withSubscriber(builder.build());
    }
    public N endSubscriber() {
      return and();
    }
    
  }
  
}