package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigurationBuilder extends ConfigurationFluent<ConfigurationBuilder> implements VisitableBuilder<Configuration,ConfigurationBuilder>{
  public ConfigurationBuilder() {
    this(false);
  }
  public ConfigurationBuilder(Boolean validationEnabled) {
    this(new Configuration(), validationEnabled);
  }
  public ConfigurationBuilder(ConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigurationBuilder(ConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Configuration(), validationEnabled);
  }
  public ConfigurationBuilder(ConfigurationFluent<?> fluent,Configuration instance) {
    this(fluent, instance, false);
  }
  public ConfigurationBuilder(ConfigurationFluent<?> fluent,Configuration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Configuration());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigurationBuilder(Configuration instance) {
    this(instance,false);
  }
  public ConfigurationBuilder(Configuration instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Configuration());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public Configuration build() {
    Configuration buildable = new Configuration(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}