package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RevisionListBuilder extends RevisionListFluent<RevisionListBuilder> implements VisitableBuilder<RevisionList,RevisionListBuilder>{
  public RevisionListBuilder() {
    this(false);
  }
  public RevisionListBuilder(Boolean validationEnabled) {
    this(new RevisionList(), validationEnabled);
  }
  public RevisionListBuilder(RevisionListFluent<?> fluent) {
    this(fluent, false);
  }
  public RevisionListBuilder(RevisionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RevisionList(), validationEnabled);
  }
  public RevisionListBuilder(RevisionListFluent<?> fluent,RevisionList instance) {
    this(fluent, instance, false);
  }
  public RevisionListBuilder(RevisionListFluent<?> fluent,RevisionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RevisionList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RevisionListBuilder(RevisionList instance) {
    this(instance,false);
  }
  public RevisionListBuilder(RevisionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RevisionList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  RevisionListFluent<?> fluent;
  Boolean validationEnabled;
  public RevisionList build() {
    RevisionList buildable = new RevisionList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}