package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RevisionSpecBuilder extends RevisionSpecFluent<RevisionSpecBuilder> implements VisitableBuilder<RevisionSpec,RevisionSpecBuilder>{
  public RevisionSpecBuilder() {
    this(false);
  }
  public RevisionSpecBuilder(Boolean validationEnabled) {
    this(new RevisionSpec(), validationEnabled);
  }
  public RevisionSpecBuilder(RevisionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RevisionSpecBuilder(RevisionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RevisionSpec(), validationEnabled);
  }
  public RevisionSpecBuilder(RevisionSpecFluent<?> fluent,RevisionSpec instance) {
    this(fluent, instance, false);
  }
  public RevisionSpecBuilder(RevisionSpecFluent<?> fluent,RevisionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RevisionSpec());

    if (instance != null) {
      fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      fluent.withAffinity(instance.getAffinity());
      fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
      fluent.withContainerConcurrency(instance.getContainerConcurrency());
      fluent.withContainers(instance.getContainers());
      fluent.withDnsConfig(instance.getDnsConfig());
      fluent.withDnsPolicy(instance.getDnsPolicy());
      fluent.withEnableServiceLinks(instance.getEnableServiceLinks());
      fluent.withEphemeralContainers(instance.getEphemeralContainers());
      fluent.withHostAliases(instance.getHostAliases());
      fluent.withHostIPC(instance.getHostIPC());
      fluent.withHostNetwork(instance.getHostNetwork());
      fluent.withHostPID(instance.getHostPID());
      fluent.withHostUsers(instance.getHostUsers());
      fluent.withHostname(instance.getHostname());
      fluent.withIdleTimeoutSeconds(instance.getIdleTimeoutSeconds());
      fluent.withImagePullSecrets(instance.getImagePullSecrets());
      fluent.withInitContainers(instance.getInitContainers());
      fluent.withNodeName(instance.getNodeName());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withOs(instance.getOs());
      fluent.withOverhead(instance.getOverhead());
      fluent.withPreemptionPolicy(instance.getPreemptionPolicy());
      fluent.withPriority(instance.getPriority());
      fluent.withPriorityClassName(instance.getPriorityClassName());
      fluent.withReadinessGates(instance.getReadinessGates());
      fluent.withResourceClaims(instance.getResourceClaims());
      fluent.withResponseStartTimeoutSeconds(instance.getResponseStartTimeoutSeconds());
      fluent.withRestartPolicy(instance.getRestartPolicy());
      fluent.withRuntimeClassName(instance.getRuntimeClassName());
      fluent.withSchedulerName(instance.getSchedulerName());
      fluent.withSchedulingGates(instance.getSchedulingGates());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
      fluent.withShareProcessNamespace(instance.getShareProcessNamespace());
      fluent.withSubdomain(instance.getSubdomain());
      fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withTolerations(instance.getTolerations());
      fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      fluent.withVolumes(instance.getVolumes());
      fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      fluent.withAffinity(instance.getAffinity());
      fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
      fluent.withContainerConcurrency(instance.getContainerConcurrency());
      fluent.withContainers(instance.getContainers());
      fluent.withDnsConfig(instance.getDnsConfig());
      fluent.withDnsPolicy(instance.getDnsPolicy());
      fluent.withEnableServiceLinks(instance.getEnableServiceLinks());
      fluent.withEphemeralContainers(instance.getEphemeralContainers());
      fluent.withHostAliases(instance.getHostAliases());
      fluent.withHostIPC(instance.getHostIPC());
      fluent.withHostNetwork(instance.getHostNetwork());
      fluent.withHostPID(instance.getHostPID());
      fluent.withHostUsers(instance.getHostUsers());
      fluent.withHostname(instance.getHostname());
      fluent.withIdleTimeoutSeconds(instance.getIdleTimeoutSeconds());
      fluent.withImagePullSecrets(instance.getImagePullSecrets());
      fluent.withInitContainers(instance.getInitContainers());
      fluent.withNodeName(instance.getNodeName());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withOs(instance.getOs());
      fluent.withOverhead(instance.getOverhead());
      fluent.withPreemptionPolicy(instance.getPreemptionPolicy());
      fluent.withPriority(instance.getPriority());
      fluent.withPriorityClassName(instance.getPriorityClassName());
      fluent.withReadinessGates(instance.getReadinessGates());
      fluent.withResourceClaims(instance.getResourceClaims());
      fluent.withResponseStartTimeoutSeconds(instance.getResponseStartTimeoutSeconds());
      fluent.withRestartPolicy(instance.getRestartPolicy());
      fluent.withRuntimeClassName(instance.getRuntimeClassName());
      fluent.withSchedulerName(instance.getSchedulerName());
      fluent.withSchedulingGates(instance.getSchedulingGates());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
      fluent.withShareProcessNamespace(instance.getShareProcessNamespace());
      fluent.withSubdomain(instance.getSubdomain());
      fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withTolerations(instance.getTolerations());
      fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      fluent.withVolumes(instance.getVolumes());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RevisionSpecBuilder(RevisionSpec instance) {
    this(instance,false);
  }
  public RevisionSpecBuilder(RevisionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RevisionSpec());

    if (instance != null) {
      this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      this.withAffinity(instance.getAffinity());
      this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
      this.withContainerConcurrency(instance.getContainerConcurrency());
      this.withContainers(instance.getContainers());
      this.withDnsConfig(instance.getDnsConfig());
      this.withDnsPolicy(instance.getDnsPolicy());
      this.withEnableServiceLinks(instance.getEnableServiceLinks());
      this.withEphemeralContainers(instance.getEphemeralContainers());
      this.withHostAliases(instance.getHostAliases());
      this.withHostIPC(instance.getHostIPC());
      this.withHostNetwork(instance.getHostNetwork());
      this.withHostPID(instance.getHostPID());
      this.withHostUsers(instance.getHostUsers());
      this.withHostname(instance.getHostname());
      this.withIdleTimeoutSeconds(instance.getIdleTimeoutSeconds());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withInitContainers(instance.getInitContainers());
      this.withNodeName(instance.getNodeName());
      this.withNodeSelector(instance.getNodeSelector());
      this.withOs(instance.getOs());
      this.withOverhead(instance.getOverhead());
      this.withPreemptionPolicy(instance.getPreemptionPolicy());
      this.withPriority(instance.getPriority());
      this.withPriorityClassName(instance.getPriorityClassName());
      this.withReadinessGates(instance.getReadinessGates());
      this.withResourceClaims(instance.getResourceClaims());
      this.withResponseStartTimeoutSeconds(instance.getResponseStartTimeoutSeconds());
      this.withRestartPolicy(instance.getRestartPolicy());
      this.withRuntimeClassName(instance.getRuntimeClassName());
      this.withSchedulerName(instance.getSchedulerName());
      this.withSchedulingGates(instance.getSchedulingGates());
      this.withSecurityContext(instance.getSecurityContext());
      this.withServiceAccount(instance.getServiceAccount());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
      this.withShareProcessNamespace(instance.getShareProcessNamespace());
      this.withSubdomain(instance.getSubdomain());
      this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withTolerations(instance.getTolerations());
      this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      this.withVolumes(instance.getVolumes());
      this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      this.withAffinity(instance.getAffinity());
      this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
      this.withContainerConcurrency(instance.getContainerConcurrency());
      this.withContainers(instance.getContainers());
      this.withDnsConfig(instance.getDnsConfig());
      this.withDnsPolicy(instance.getDnsPolicy());
      this.withEnableServiceLinks(instance.getEnableServiceLinks());
      this.withEphemeralContainers(instance.getEphemeralContainers());
      this.withHostAliases(instance.getHostAliases());
      this.withHostIPC(instance.getHostIPC());
      this.withHostNetwork(instance.getHostNetwork());
      this.withHostPID(instance.getHostPID());
      this.withHostUsers(instance.getHostUsers());
      this.withHostname(instance.getHostname());
      this.withIdleTimeoutSeconds(instance.getIdleTimeoutSeconds());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withInitContainers(instance.getInitContainers());
      this.withNodeName(instance.getNodeName());
      this.withNodeSelector(instance.getNodeSelector());
      this.withOs(instance.getOs());
      this.withOverhead(instance.getOverhead());
      this.withPreemptionPolicy(instance.getPreemptionPolicy());
      this.withPriority(instance.getPriority());
      this.withPriorityClassName(instance.getPriorityClassName());
      this.withReadinessGates(instance.getReadinessGates());
      this.withResourceClaims(instance.getResourceClaims());
      this.withResponseStartTimeoutSeconds(instance.getResponseStartTimeoutSeconds());
      this.withRestartPolicy(instance.getRestartPolicy());
      this.withRuntimeClassName(instance.getRuntimeClassName());
      this.withSchedulerName(instance.getSchedulerName());
      this.withSchedulingGates(instance.getSchedulingGates());
      this.withSecurityContext(instance.getSecurityContext());
      this.withServiceAccount(instance.getServiceAccount());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
      this.withShareProcessNamespace(instance.getShareProcessNamespace());
      this.withSubdomain(instance.getSubdomain());
      this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withTolerations(instance.getTolerations());
      this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      this.withVolumes(instance.getVolumes());
    }
    this.validationEnabled = validationEnabled; 
  }
  RevisionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RevisionSpec build() {
    RevisionSpec buildable = new RevisionSpec(fluent.getActiveDeadlineSeconds(),fluent.getAffinity(),fluent.getAutomountServiceAccountToken(),fluent.getContainerConcurrency(),fluent.buildContainers(),fluent.getDnsConfig(),fluent.getDnsPolicy(),fluent.getEnableServiceLinks(),fluent.getEphemeralContainers(),fluent.getHostAliases(),fluent.getHostIPC(),fluent.getHostNetwork(),fluent.getHostPID(),fluent.getHostUsers(),fluent.getHostname(),fluent.getIdleTimeoutSeconds(),fluent.buildImagePullSecrets(),fluent.buildInitContainers(),fluent.getNodeName(),fluent.getNodeSelector(),fluent.getOs(),fluent.getOverhead(),fluent.getPreemptionPolicy(),fluent.getPriority(),fluent.getPriorityClassName(),fluent.getReadinessGates(),fluent.getResourceClaims(),fluent.getResponseStartTimeoutSeconds(),fluent.getRestartPolicy(),fluent.getRuntimeClassName(),fluent.getSchedulerName(),fluent.getSchedulingGates(),fluent.getSecurityContext(),fluent.getServiceAccount(),fluent.getServiceAccountName(),fluent.getSetHostnameAsFQDN(),fluent.getShareProcessNamespace(),fluent.getSubdomain(),fluent.getTerminationGracePeriodSeconds(),fluent.getTimeoutSeconds(),fluent.getTolerations(),fluent.getTopologySpreadConstraints(),fluent.buildVolumes());
    return buildable;
  }
  
}