package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteSpecBuilder extends RouteSpecFluent<RouteSpecBuilder> implements VisitableBuilder<RouteSpec,RouteSpecBuilder>{
  public RouteSpecBuilder() {
    this(false);
  }
  public RouteSpecBuilder(Boolean validationEnabled) {
    this(new RouteSpec(), validationEnabled);
  }
  public RouteSpecBuilder(RouteSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteSpecBuilder(RouteSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteSpec(), validationEnabled);
  }
  public RouteSpecBuilder(RouteSpecFluent<?> fluent,RouteSpec instance) {
    this(fluent, instance, false);
  }
  public RouteSpecBuilder(RouteSpecFluent<?> fluent,RouteSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RouteSpec());

    if (instance != null) {
      fluent.withTraffic(instance.getTraffic());
      fluent.withTraffic(instance.getTraffic());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RouteSpecBuilder(RouteSpec instance) {
    this(instance,false);
  }
  public RouteSpecBuilder(RouteSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RouteSpec());

    if (instance != null) {
      this.withTraffic(instance.getTraffic());
      this.withTraffic(instance.getTraffic());
    }
    this.validationEnabled = validationEnabled; 
  }
  RouteSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RouteSpec build() {
    RouteSpec buildable = new RouteSpec(fluent.buildTraffic());
    return buildable;
  }
  
}