package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DomainMappingStatusBuilder extends DomainMappingStatusFluent<DomainMappingStatusBuilder> implements VisitableBuilder<DomainMappingStatus,DomainMappingStatusBuilder>{
  public DomainMappingStatusBuilder() {
    this(false);
  }
  public DomainMappingStatusBuilder(Boolean validationEnabled) {
    this(new DomainMappingStatus(), validationEnabled);
  }
  public DomainMappingStatusBuilder(DomainMappingStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DomainMappingStatusBuilder(DomainMappingStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DomainMappingStatus(), validationEnabled);
  }
  public DomainMappingStatusBuilder(DomainMappingStatusFluent<?> fluent,DomainMappingStatus instance) {
    this(fluent, instance, false);
  }
  public DomainMappingStatusBuilder(DomainMappingStatusFluent<?> fluent,DomainMappingStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DomainMappingStatus());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withUrl(instance.getUrl());
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DomainMappingStatusBuilder(DomainMappingStatus instance) {
    this(instance,false);
  }
  public DomainMappingStatusBuilder(DomainMappingStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DomainMappingStatus());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withUrl(instance.getUrl());
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  DomainMappingStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DomainMappingStatus build() {
    DomainMappingStatus buildable = new DomainMappingStatus(fluent.buildAddress(),fluent.getAnnotations(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.getUrl());
    return buildable;
  }
  
}