package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApiServerSourceStatusBuilder extends ApiServerSourceStatusFluent<ApiServerSourceStatusBuilder> implements VisitableBuilder<ApiServerSourceStatus,ApiServerSourceStatusBuilder>{
  public ApiServerSourceStatusBuilder() {
    this(false);
  }
  public ApiServerSourceStatusBuilder(Boolean validationEnabled) {
    this(new ApiServerSourceStatus(), validationEnabled);
  }
  public ApiServerSourceStatusBuilder(ApiServerSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ApiServerSourceStatusBuilder(ApiServerSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApiServerSourceStatus(), validationEnabled);
  }
  public ApiServerSourceStatusBuilder(ApiServerSourceStatusFluent<?> fluent,ApiServerSourceStatus instance) {
    this(fluent, instance, false);
  }
  public ApiServerSourceStatusBuilder(ApiServerSourceStatusFluent<?> fluent,ApiServerSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ApiServerSourceStatus());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkCACerts(instance.getSinkCACerts());
      fluent.withSinkUri(instance.getSinkUri());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkCACerts(instance.getSinkCACerts());
      fluent.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ApiServerSourceStatusBuilder(ApiServerSourceStatus instance) {
    this(instance,false);
  }
  public ApiServerSourceStatusBuilder(ApiServerSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ApiServerSourceStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withNamespaces(instance.getNamespaces());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withNamespaces(instance.getNamespaces());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  ApiServerSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ApiServerSourceStatus build() {
    ApiServerSourceStatus buildable = new ApiServerSourceStatus(fluent.getAnnotations(),fluent.buildCeAttributes(),fluent.buildConditions(),fluent.getNamespaces(),fluent.getObservedGeneration(),fluent.getSinkCACerts(),fluent.getSinkUri());
    return buildable;
  }
  
}