package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerSourceStatusBuilder extends ContainerSourceStatusFluent<ContainerSourceStatusBuilder> implements VisitableBuilder<ContainerSourceStatus,ContainerSourceStatusBuilder>{
  public ContainerSourceStatusBuilder() {
    this(false);
  }
  public ContainerSourceStatusBuilder(Boolean validationEnabled) {
    this(new ContainerSourceStatus(), validationEnabled);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerSourceStatus(), validationEnabled);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent,ContainerSourceStatus instance) {
    this(fluent, instance, false);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent,ContainerSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerSourceStatus());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkCACerts(instance.getSinkCACerts());
      fluent.withSinkUri(instance.getSinkUri());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkCACerts(instance.getSinkCACerts());
      fluent.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatus instance) {
    this(instance,false);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerSourceStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerSourceStatus build() {
    ContainerSourceStatus buildable = new ContainerSourceStatus(fluent.getAnnotations(),fluent.buildCeAttributes(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.getSinkCACerts(),fluent.getSinkUri());
    return buildable;
  }
  
}