/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.knative.internal.networking.v1alpha1.HTTPIngressPath;
import io.fabric8.knative.internal.networking.v1alpha1.HeaderMatch;
import io.fabric8.knative.internal.networking.v1alpha1.IngressBackendSplit;
import io.fabric8.knative.internal.networking.v1alpha1.IngressBackendSplitBuilder;
import io.fabric8.knative.internal.networking.v1alpha1.IngressBackendSplitFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPIngressPathFluent<A extends HTTPIngressPathFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> appendHeaders;
    private Map<String, HeaderMatch> headers;
    private String path;
    private String rewriteHost;
    private ArrayList<IngressBackendSplitBuilder> splits = new ArrayList();

    public HTTPIngressPathFluent() {
    }

    public HTTPIngressPathFluent(HTTPIngressPath instance) {
        HTTPIngressPath hTTPIngressPath = instance = instance != null ? instance : new HTTPIngressPath();
        if (instance != null) {
            this.withAppendHeaders(instance.getAppendHeaders());
            this.withHeaders(instance.getHeaders());
            this.withPath(instance.getPath());
            this.withRewriteHost(instance.getRewriteHost());
            this.withSplits(instance.getSplits());
            this.withAppendHeaders(instance.getAppendHeaders());
            this.withHeaders(instance.getHeaders());
            this.withPath(instance.getPath());
            this.withRewriteHost(instance.getRewriteHost());
            this.withSplits(instance.getSplits());
        }
    }

    public A addToAppendHeaders(String key, String value) {
        if (this.appendHeaders == null && key != null && value != null) {
            this.appendHeaders = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.appendHeaders.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAppendHeaders(Map<String, String> map) {
        if (this.appendHeaders == null && map != null) {
            this.appendHeaders = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.appendHeaders.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAppendHeaders(String key) {
        if (this.appendHeaders == null) {
            return (A)((Object)this);
        }
        if (key != null && this.appendHeaders != null) {
            this.appendHeaders.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAppendHeaders(Map<String, String> map) {
        if (this.appendHeaders == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.appendHeaders == null) continue;
                this.appendHeaders.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAppendHeaders() {
        return this.appendHeaders;
    }

    public <K, V> A withAppendHeaders(Map<String, String> appendHeaders) {
        this.appendHeaders = appendHeaders == null ? null : new LinkedHashMap<String, String>(appendHeaders);
        return (A)((Object)this);
    }

    public boolean hasAppendHeaders() {
        return this.appendHeaders != null;
    }

    public A addToHeaders(String key, HeaderMatch value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, HeaderMatch>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToHeaders(Map<String, HeaderMatch> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, HeaderMatch>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(Map<String, HeaderMatch> map) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, HeaderMatch> getHeaders() {
        return this.headers;
    }

    public <K, V> A withHeaders(Map<String, HeaderMatch> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, HeaderMatch>(headers);
        return (A)((Object)this);
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getRewriteHost() {
        return this.rewriteHost;
    }

    public A withRewriteHost(String rewriteHost) {
        this.rewriteHost = rewriteHost;
        return (A)((Object)this);
    }

    public boolean hasRewriteHost() {
        return this.rewriteHost != null;
    }

    public A addToSplits(int index, IngressBackendSplit item) {
        if (this.splits == null) {
            this.splits = new ArrayList();
        }
        IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);
        if (index < 0 || index >= this.splits.size()) {
            this._visitables.get((Object)"splits").add(builder);
            this.splits.add(builder);
        } else {
            this._visitables.get((Object)"splits").add(index, builder);
            this.splits.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSplits(int index, IngressBackendSplit item) {
        if (this.splits == null) {
            this.splits = new ArrayList();
        }
        IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);
        if (index < 0 || index >= this.splits.size()) {
            this._visitables.get((Object)"splits").add(builder);
            this.splits.add(builder);
        } else {
            this._visitables.get((Object)"splits").set(index, builder);
            this.splits.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSplits(IngressBackendSplit ... items) {
        if (this.splits == null) {
            this.splits = new ArrayList();
        }
        for (IngressBackendSplit item : items) {
            IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);
            this._visitables.get((Object)"splits").add(builder);
            this.splits.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSplits(Collection<IngressBackendSplit> items) {
        if (this.splits == null) {
            this.splits = new ArrayList();
        }
        for (IngressBackendSplit item : items) {
            IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);
            this._visitables.get((Object)"splits").add(builder);
            this.splits.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSplits(IngressBackendSplit ... items) {
        if (this.splits == null) {
            return (A)((Object)this);
        }
        for (IngressBackendSplit item : items) {
            IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);
            this._visitables.get((Object)"splits").remove((Object)builder);
            this.splits.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSplits(Collection<IngressBackendSplit> items) {
        if (this.splits == null) {
            return (A)((Object)this);
        }
        for (IngressBackendSplit item : items) {
            IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);
            this._visitables.get((Object)"splits").remove((Object)builder);
            this.splits.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSplits(Predicate<IngressBackendSplitBuilder> predicate) {
        if (this.splits == null) {
            return (A)((Object)this);
        }
        Iterator<IngressBackendSplitBuilder> each = this.splits.iterator();
        List visitables = this._visitables.get((Object)"splits");
        while (each.hasNext()) {
            IngressBackendSplitBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IngressBackendSplit> buildSplits() {
        return this.splits != null ? HTTPIngressPathFluent.build(this.splits) : null;
    }

    public IngressBackendSplit buildSplit(int index) {
        return this.splits.get(index).build();
    }

    public IngressBackendSplit buildFirstSplit() {
        return this.splits.get(0).build();
    }

    public IngressBackendSplit buildLastSplit() {
        return this.splits.get(this.splits.size() - 1).build();
    }

    public IngressBackendSplit buildMatchingSplit(Predicate<IngressBackendSplitBuilder> predicate) {
        for (IngressBackendSplitBuilder item : this.splits) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSplit(Predicate<IngressBackendSplitBuilder> predicate) {
        for (IngressBackendSplitBuilder item : this.splits) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSplits(List<IngressBackendSplit> splits) {
        if (this.splits != null) {
            this._visitables.get((Object)"splits").clear();
        }
        if (splits != null) {
            this.splits = new ArrayList();
            for (IngressBackendSplit item : splits) {
                this.addToSplits(item);
            }
        } else {
            this.splits = null;
        }
        return (A)((Object)this);
    }

    public A withSplits(IngressBackendSplit ... splits) {
        if (this.splits != null) {
            this.splits.clear();
            this._visitables.remove((Object)"splits");
        }
        if (splits != null) {
            for (IngressBackendSplit item : splits) {
                this.addToSplits(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSplits() {
        return this.splits != null && !this.splits.isEmpty();
    }

    public SplitsNested<A> addNewSplit() {
        return new SplitsNested(-1, null);
    }

    public SplitsNested<A> addNewSplitLike(IngressBackendSplit item) {
        return new SplitsNested(-1, item);
    }

    public SplitsNested<A> setNewSplitLike(int index, IngressBackendSplit item) {
        return new SplitsNested(index, item);
    }

    public SplitsNested<A> editSplit(int index) {
        if (this.splits.size() <= index) {
            throw new RuntimeException("Can't edit splits. Index exceeds size.");
        }
        return this.setNewSplitLike(index, this.buildSplit(index));
    }

    public SplitsNested<A> editFirstSplit() {
        if (this.splits.size() == 0) {
            throw new RuntimeException("Can't edit first splits. The list is empty.");
        }
        return this.setNewSplitLike(0, this.buildSplit(0));
    }

    public SplitsNested<A> editLastSplit() {
        int index = this.splits.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last splits. The list is empty.");
        }
        return this.setNewSplitLike(index, this.buildSplit(index));
    }

    public SplitsNested<A> editMatchingSplit(Predicate<IngressBackendSplitBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.splits.size(); ++i) {
            if (!predicate.test(this.splits.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching splits. No match found.");
        }
        return this.setNewSplitLike(index, this.buildSplit(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPIngressPathFluent that = (HTTPIngressPathFluent)((Object)o);
        if (!Objects.equals(this.appendHeaders, that.appendHeaders)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.rewriteHost, that.rewriteHost)) {
            return false;
        }
        return Objects.equals(this.splits, that.splits);
    }

    public int hashCode() {
        return Objects.hash(this.appendHeaders, this.headers, this.path, this.rewriteHost, this.splits, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appendHeaders != null && !this.appendHeaders.isEmpty()) {
            sb.append("appendHeaders:");
            sb.append(this.appendHeaders + ",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.rewriteHost != null) {
            sb.append("rewriteHost:");
            sb.append(this.rewriteHost + ",");
        }
        if (this.splits != null && !this.splits.isEmpty()) {
            sb.append("splits:");
            sb.append(this.splits);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SplitsNested<N>
    extends IngressBackendSplitFluent<SplitsNested<N>>
    implements Nested<N> {
        IngressBackendSplitBuilder builder;
        int index;

        SplitsNested(int index, IngressBackendSplit item) {
            this.index = index;
            this.builder = new IngressBackendSplitBuilder(this, item);
        }

        public N and() {
            return (N)HTTPIngressPathFluent.this.setToSplits(this.index, this.builder.build());
        }

        public N endSplit() {
            return this.and();
        }
    }
}

