package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CouchDbSourceBuilder extends CouchDbSourceFluent<CouchDbSourceBuilder> implements VisitableBuilder<CouchDbSource,CouchDbSourceBuilder>{
  public CouchDbSourceBuilder() {
    this(new CouchDbSource());
  }
  
  public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent) {
    this(fluent, new CouchDbSource());
  }
  
  public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent,CouchDbSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CouchDbSourceBuilder(CouchDbSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CouchDbSourceFluent<?> fluent;
  
  public CouchDbSource build() {
    CouchDbSource buildable = new CouchDbSource(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}