package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CouchDbSourceSpecFluent<A extends CouchDbSourceSpecFluent<A>> extends BaseFluent<A>{
  public CouchDbSourceSpecFluent() {
  }
  
  public CouchDbSourceSpecFluent(CouchDbSourceSpec instance) {
    this.copyInstance(instance);
  }
  private ObjectReferenceBuilder credentials;
  private String database;
  private String feed;
  private String serviceAccountName;
  private DestinationBuilder sink;
  
  protected void copyInstance(CouchDbSourceSpec instance) {
    instance = (instance != null ? instance : new CouchDbSourceSpec());
  
    if (instance != null) {
        this.withCredentials(instance.getCredentials());
        this.withDatabase(instance.getDatabase());
        this.withFeed(instance.getFeed());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSink(instance.getSink());
        this.withCredentials(instance.getCredentials());
        this.withDatabase(instance.getDatabase());
        this.withFeed(instance.getFeed());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSink(instance.getSink());
      }
  }
  
  public ObjectReference buildCredentials() {
    return this.credentials!=null ?this.credentials.build():null;
  }
  
  public A withCredentials(ObjectReference credentials) {
    _visitables.get("credentials").remove(this.credentials);
    if (credentials!=null){ this.credentials= new ObjectReferenceBuilder(credentials); _visitables.get("credentials").add(this.credentials);} else { this.credentials = null; _visitables.get("credentials").remove(this.credentials); } return (A) this;
  }
  
  public boolean hasCredentials() {
    return this.credentials != null;
  }
  
  public CredentialsNested<A> withNewCredentials() {
    return new CredentialsNested(null);
  }
  
  public CredentialsNested<A> withNewCredentialsLike(ObjectReference item) {
    return new CredentialsNested(item);
  }
  
  public CredentialsNested<A> editCredentials() {
    return withNewCredentialsLike(java.util.Optional.ofNullable(buildCredentials()).orElse(null));
  }
  
  public CredentialsNested<A> editOrNewCredentials() {
    return withNewCredentialsLike(java.util.Optional.ofNullable(buildCredentials()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public CredentialsNested<A> editOrNewCredentialsLike(ObjectReference item) {
    return withNewCredentialsLike(java.util.Optional.ofNullable(buildCredentials()).orElse(item));
  }
  
  public String getDatabase() {
    return this.database;
  }
  
  public A withDatabase(String database) {
    this.database=database; return (A) this;
  }
  
  public boolean hasDatabase() {
    return this.database != null;
  }
  
  public String getFeed() {
    return this.feed;
  }
  
  public A withFeed(String feed) {
    this.feed=feed; return (A) this;
  }
  
  public boolean hasFeed() {
    return this.feed != null;
  }
  
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  public Destination buildSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  
  public A withSink(Destination sink) {
    _visitables.get("sink").remove(this.sink);
    if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} else { this.sink = null; _visitables.get("sink").remove(this.sink); } return (A) this;
  }
  
  public boolean hasSink() {
    return this.sink != null;
  }
  
  public SinkNested<A> withNewSink() {
    return new SinkNested(null);
  }
  
  public SinkNested<A> withNewSinkLike(Destination item) {
    return new SinkNested(item);
  }
  
  public SinkNested<A> editSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(null));
  }
  
  public SinkNested<A> editOrNewSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(new DestinationBuilder().build()));
  }
  
  public SinkNested<A> editOrNewSinkLike(Destination item) {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CouchDbSourceSpecFluent that = (CouchDbSourceSpecFluent) o;
    if (!java.util.Objects.equals(credentials, that.credentials)) return false;
  
    if (!java.util.Objects.equals(database, that.database)) return false;
  
    if (!java.util.Objects.equals(feed, that.feed)) return false;
  
    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;
  
    if (!java.util.Objects.equals(sink, that.sink)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(credentials,  database,  feed,  serviceAccountName,  sink,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (credentials != null) { sb.append("credentials:"); sb.append(credentials + ","); }
    if (database != null) { sb.append("database:"); sb.append(database + ","); }
    if (feed != null) { sb.append("feed:"); sb.append(feed + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink); }
    sb.append("}");
    return sb.toString();
  }
  public class CredentialsNested<N> extends ObjectReferenceFluent<CredentialsNested<N>> implements Nested<N>{
    CredentialsNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) CouchDbSourceSpecFluent.this.withCredentials(builder.build());
    }
    
    public N endCredentials() {
      return and();
    }
    
  
  }
  public class SinkNested<N> extends DestinationFluent<SinkNested<N>> implements Nested<N>{
    SinkNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) CouchDbSourceSpecFluent.this.withSink(builder.build());
    }
    
    public N endSink() {
      return and();
    }
    
  
  }

}