package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GitHubSourceSpecBuilder extends GitHubSourceSpecFluent<GitHubSourceSpecBuilder> implements VisitableBuilder<GitHubSourceSpec,GitHubSourceSpecBuilder>{
  public GitHubSourceSpecBuilder() {
    this(new GitHubSourceSpec());
  }
  
  public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent) {
    this(fluent, new GitHubSourceSpec());
  }
  
  public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent,GitHubSourceSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GitHubSourceSpecBuilder(GitHubSourceSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GitHubSourceSpecFluent<?> fluent;
  
  public GitHubSourceSpec build() {
    GitHubSourceSpec buildable = new GitHubSourceSpec(fluent.buildAccessToken(),fluent.buildCeOverrides(),fluent.getEventTypes(),fluent.getGithubAPIURL(),fluent.getOwnerAndRepository(),fluent.buildSecretToken(),fluent.getSecure(),fluent.getServiceAccountName(),fluent.buildSink());
    return buildable;
  }
  

}