package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GitLabSourceBuilder extends GitLabSourceFluent<GitLabSourceBuilder> implements VisitableBuilder<GitLabSource,GitLabSourceBuilder>{
  public GitLabSourceBuilder() {
    this(new GitLabSource());
  }
  
  public GitLabSourceBuilder(GitLabSourceFluent<?> fluent) {
    this(fluent, new GitLabSource());
  }
  
  public GitLabSourceBuilder(GitLabSourceFluent<?> fluent,GitLabSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GitLabSourceBuilder(GitLabSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GitLabSourceFluent<?> fluent;
  
  public GitLabSource build() {
    GitLabSource buildable = new GitLabSource(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}