package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GitLabSourceSpecFluent<A extends GitLabSourceSpecFluent<A>> extends BaseFluent<A>{
  public GitLabSourceSpecFluent() {
  }
  
  public GitLabSourceSpecFluent(GitLabSourceSpec instance) {
    this.copyInstance(instance);
  }
  private SecretValueFromSourceBuilder accessToken;
  private CloudEventOverridesBuilder ceOverrides;
  private List<String> eventTypes = new ArrayList<String>();
  private String projectUrl;
  private SecretValueFromSourceBuilder secretToken;
  private String serviceAccountName;
  private DestinationBuilder sink;
  private Boolean sslverify;
  
  protected void copyInstance(GitLabSourceSpec instance) {
    instance = (instance != null ? instance : new GitLabSourceSpec());
  
    if (instance != null) {
        this.withAccessToken(instance.getAccessToken());
        this.withCeOverrides(instance.getCeOverrides());
        this.withEventTypes(instance.getEventTypes());
        this.withProjectUrl(instance.getProjectUrl());
        this.withSecretToken(instance.getSecretToken());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSink(instance.getSink());
        this.withSslverify(instance.getSslverify());
        this.withAccessToken(instance.getAccessToken());
        this.withCeOverrides(instance.getCeOverrides());
        this.withEventTypes(instance.getEventTypes());
        this.withProjectUrl(instance.getProjectUrl());
        this.withSecretToken(instance.getSecretToken());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSink(instance.getSink());
        this.withSslverify(instance.getSslverify());
      }
  }
  
  public SecretValueFromSource buildAccessToken() {
    return this.accessToken!=null ?this.accessToken.build():null;
  }
  
  public A withAccessToken(SecretValueFromSource accessToken) {
    _visitables.get("accessToken").remove(this.accessToken);
    if (accessToken!=null){ this.accessToken= new SecretValueFromSourceBuilder(accessToken); _visitables.get("accessToken").add(this.accessToken);} else { this.accessToken = null; _visitables.get("accessToken").remove(this.accessToken); } return (A) this;
  }
  
  public boolean hasAccessToken() {
    return this.accessToken != null;
  }
  
  public AccessTokenNested<A> withNewAccessToken() {
    return new AccessTokenNested(null);
  }
  
  public AccessTokenNested<A> withNewAccessTokenLike(SecretValueFromSource item) {
    return new AccessTokenNested(item);
  }
  
  public AccessTokenNested<A> editAccessToken() {
    return withNewAccessTokenLike(java.util.Optional.ofNullable(buildAccessToken()).orElse(null));
  }
  
  public AccessTokenNested<A> editOrNewAccessToken() {
    return withNewAccessTokenLike(java.util.Optional.ofNullable(buildAccessToken()).orElse(new SecretValueFromSourceBuilder().build()));
  }
  
  public AccessTokenNested<A> editOrNewAccessTokenLike(SecretValueFromSource item) {
    return withNewAccessTokenLike(java.util.Optional.ofNullable(buildAccessToken()).orElse(item));
  }
  
  public CloudEventOverrides buildCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  
  public A withCeOverrides(CloudEventOverrides ceOverrides) {
    _visitables.get("ceOverrides").remove(this.ceOverrides);
    if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} else { this.ceOverrides = null; _visitables.get("ceOverrides").remove(this.ceOverrides); } return (A) this;
  }
  
  public boolean hasCeOverrides() {
    return this.ceOverrides != null;
  }
  
  public CeOverridesNested<A> withNewCeOverrides() {
    return new CeOverridesNested(null);
  }
  
  public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
    return new CeOverridesNested(item);
  }
  
  public CeOverridesNested<A> editCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(null));
  }
  
  public CeOverridesNested<A> editOrNewCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
  }
  
  public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(item));
  }
  
  public A addToEventTypes(int index,String item) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    this.eventTypes.add(index, item);
    return (A)this;
  }
  
  public A setToEventTypes(int index,String item) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    this.eventTypes.set(index, item); return (A)this;
  }
  
  public A addToEventTypes(java.lang.String... items) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    for (String item : items) {this.eventTypes.add(item);} return (A)this;
  }
  
  public A addAllToEventTypes(Collection<String> items) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    for (String item : items) {this.eventTypes.add(item);} return (A)this;
  }
  
  public A removeFromEventTypes(java.lang.String... items) {
    if (this.eventTypes == null) return (A)this;
    for (String item : items) { this.eventTypes.remove(item);} return (A)this;
  }
  
  public A removeAllFromEventTypes(Collection<String> items) {
    if (this.eventTypes == null) return (A)this;
    for (String item : items) { this.eventTypes.remove(item);} return (A)this;
  }
  
  public List<String> getEventTypes() {
    return this.eventTypes;
  }
  
  public String getEventType(int index) {
    return this.eventTypes.get(index);
  }
  
  public String getFirstEventType() {
    return this.eventTypes.get(0);
  }
  
  public String getLastEventType() {
    return this.eventTypes.get(eventTypes.size() - 1);
  }
  
  public String getMatchingEventType(Predicate<String> predicate) {
    for (String item: eventTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingEventType(Predicate<String> predicate) {
    for (String item: eventTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withEventTypes(List<String> eventTypes) {
    if (eventTypes != null) {this.eventTypes = new ArrayList(); for (String item : eventTypes){this.addToEventTypes(item);}} else { this.eventTypes = null;} return (A) this;
  }
  
  public A withEventTypes(java.lang.String... eventTypes) {
    if (this.eventTypes != null) {this.eventTypes.clear(); _visitables.remove("eventTypes"); }
    if (eventTypes != null) {for (String item :eventTypes){ this.addToEventTypes(item);}} return (A) this;
  }
  
  public boolean hasEventTypes() {
    return eventTypes != null && !eventTypes.isEmpty();
  }
  
  public String getProjectUrl() {
    return this.projectUrl;
  }
  
  public A withProjectUrl(String projectUrl) {
    this.projectUrl=projectUrl; return (A) this;
  }
  
  public boolean hasProjectUrl() {
    return this.projectUrl != null;
  }
  
  public SecretValueFromSource buildSecretToken() {
    return this.secretToken!=null ?this.secretToken.build():null;
  }
  
  public A withSecretToken(SecretValueFromSource secretToken) {
    _visitables.get("secretToken").remove(this.secretToken);
    if (secretToken!=null){ this.secretToken= new SecretValueFromSourceBuilder(secretToken); _visitables.get("secretToken").add(this.secretToken);} else { this.secretToken = null; _visitables.get("secretToken").remove(this.secretToken); } return (A) this;
  }
  
  public boolean hasSecretToken() {
    return this.secretToken != null;
  }
  
  public SecretTokenNested<A> withNewSecretToken() {
    return new SecretTokenNested(null);
  }
  
  public SecretTokenNested<A> withNewSecretTokenLike(SecretValueFromSource item) {
    return new SecretTokenNested(item);
  }
  
  public SecretTokenNested<A> editSecretToken() {
    return withNewSecretTokenLike(java.util.Optional.ofNullable(buildSecretToken()).orElse(null));
  }
  
  public SecretTokenNested<A> editOrNewSecretToken() {
    return withNewSecretTokenLike(java.util.Optional.ofNullable(buildSecretToken()).orElse(new SecretValueFromSourceBuilder().build()));
  }
  
  public SecretTokenNested<A> editOrNewSecretTokenLike(SecretValueFromSource item) {
    return withNewSecretTokenLike(java.util.Optional.ofNullable(buildSecretToken()).orElse(item));
  }
  
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  public Destination buildSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  
  public A withSink(Destination sink) {
    _visitables.get("sink").remove(this.sink);
    if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} else { this.sink = null; _visitables.get("sink").remove(this.sink); } return (A) this;
  }
  
  public boolean hasSink() {
    return this.sink != null;
  }
  
  public SinkNested<A> withNewSink() {
    return new SinkNested(null);
  }
  
  public SinkNested<A> withNewSinkLike(Destination item) {
    return new SinkNested(item);
  }
  
  public SinkNested<A> editSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(null));
  }
  
  public SinkNested<A> editOrNewSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(new DestinationBuilder().build()));
  }
  
  public SinkNested<A> editOrNewSinkLike(Destination item) {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(item));
  }
  
  public Boolean getSslverify() {
    return this.sslverify;
  }
  
  public A withSslverify(Boolean sslverify) {
    this.sslverify=sslverify; return (A) this;
  }
  
  public boolean hasSslverify() {
    return this.sslverify != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitLabSourceSpecFluent that = (GitLabSourceSpecFluent) o;
    if (!java.util.Objects.equals(accessToken, that.accessToken)) return false;
  
    if (!java.util.Objects.equals(ceOverrides, that.ceOverrides)) return false;
  
    if (!java.util.Objects.equals(eventTypes, that.eventTypes)) return false;
  
    if (!java.util.Objects.equals(projectUrl, that.projectUrl)) return false;
  
    if (!java.util.Objects.equals(secretToken, that.secretToken)) return false;
  
    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;
  
    if (!java.util.Objects.equals(sink, that.sink)) return false;
  
    if (!java.util.Objects.equals(sslverify, that.sslverify)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessToken,  ceOverrides,  eventTypes,  projectUrl,  secretToken,  serviceAccountName,  sink,  sslverify,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessToken != null) { sb.append("accessToken:"); sb.append(accessToken + ","); }
    if (ceOverrides != null) { sb.append("ceOverrides:"); sb.append(ceOverrides + ","); }
    if (eventTypes != null && !eventTypes.isEmpty()) { sb.append("eventTypes:"); sb.append(eventTypes + ","); }
    if (projectUrl != null) { sb.append("projectUrl:"); sb.append(projectUrl + ","); }
    if (secretToken != null) { sb.append("secretToken:"); sb.append(secretToken + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink + ","); }
    if (sslverify != null) { sb.append("sslverify:"); sb.append(sslverify); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSslverify() {
    return withSslverify(true);
  }
  public class AccessTokenNested<N> extends SecretValueFromSourceFluent<AccessTokenNested<N>> implements Nested<N>{
    AccessTokenNested(SecretValueFromSource item) {
      this.builder = new SecretValueFromSourceBuilder(this, item);
    }
    SecretValueFromSourceBuilder builder;
    
    public N and() {
      return (N) GitLabSourceSpecFluent.this.withAccessToken(builder.build());
    }
    
    public N endAccessToken() {
      return and();
    }
    
  
  }
  public class CeOverridesNested<N> extends CloudEventOverridesFluent<CeOverridesNested<N>> implements Nested<N>{
    CeOverridesNested(CloudEventOverrides item) {
      this.builder = new CloudEventOverridesBuilder(this, item);
    }
    CloudEventOverridesBuilder builder;
    
    public N and() {
      return (N) GitLabSourceSpecFluent.this.withCeOverrides(builder.build());
    }
    
    public N endCeOverrides() {
      return and();
    }
    
  
  }
  public class SecretTokenNested<N> extends SecretValueFromSourceFluent<SecretTokenNested<N>> implements Nested<N>{
    SecretTokenNested(SecretValueFromSource item) {
      this.builder = new SecretValueFromSourceBuilder(this, item);
    }
    SecretValueFromSourceBuilder builder;
    
    public N and() {
      return (N) GitLabSourceSpecFluent.this.withSecretToken(builder.build());
    }
    
    public N endSecretToken() {
      return and();
    }
    
  
  }
  public class SinkNested<N> extends DestinationFluent<SinkNested<N>> implements Nested<N>{
    SinkNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) GitLabSourceSpecFluent.this.withSink(builder.build());
    }
    
    public N endSink() {
      return and();
    }
    
  
  }

}