package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaChannelSpecBuilder extends KafkaChannelSpecFluent<KafkaChannelSpecBuilder> implements VisitableBuilder<KafkaChannelSpec,KafkaChannelSpecBuilder>{
  public KafkaChannelSpecBuilder() {
    this(new KafkaChannelSpec());
  }
  
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent) {
    this(fluent, new KafkaChannelSpec());
  }
  
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent,KafkaChannelSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaChannelSpecBuilder(KafkaChannelSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaChannelSpecFluent<?> fluent;
  
  public KafkaChannelSpec build() {
    KafkaChannelSpec buildable = new KafkaChannelSpec(fluent.buildDelivery(),fluent.getNumPartitions(),fluent.getReplicationFactor(),fluent.getRetentionDuration(),fluent.buildSubscribers());
    return buildable;
  }
  

}