package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import java.lang.Integer;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaSourceSpecFluent<A extends KafkaSourceSpecFluent<A>> extends BaseFluent<A>{
  public KafkaSourceSpecFluent() {
  }
  
  public KafkaSourceSpecFluent(KafkaSourceSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> bootstrapServers = new ArrayList<String>();
  private CloudEventOverridesBuilder ceOverrides;
  private String consumerGroup;
  private Integer consumers;
  private DeliverySpecBuilder delivery;
  private String initialOffset;
  private KafkaNetSpecBuilder net;
  private DestinationBuilder sink;
  private List<String> topics = new ArrayList<String>();
  
  protected void copyInstance(KafkaSourceSpec instance) {
    instance = (instance != null ? instance : new KafkaSourceSpec());
  
    if (instance != null) {
        this.withBootstrapServers(instance.getBootstrapServers());
        this.withCeOverrides(instance.getCeOverrides());
        this.withConsumerGroup(instance.getConsumerGroup());
        this.withConsumers(instance.getConsumers());
        this.withDelivery(instance.getDelivery());
        this.withInitialOffset(instance.getInitialOffset());
        this.withNet(instance.getNet());
        this.withSink(instance.getSink());
        this.withTopics(instance.getTopics());
        this.withBootstrapServers(instance.getBootstrapServers());
        this.withCeOverrides(instance.getCeOverrides());
        this.withConsumerGroup(instance.getConsumerGroup());
        this.withConsumers(instance.getConsumers());
        this.withDelivery(instance.getDelivery());
        this.withInitialOffset(instance.getInitialOffset());
        this.withNet(instance.getNet());
        this.withSink(instance.getSink());
        this.withTopics(instance.getTopics());
      }
  }
  
  public A addToBootstrapServers(int index,String item) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    this.bootstrapServers.add(index, item);
    return (A)this;
  }
  
  public A setToBootstrapServers(int index,String item) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    this.bootstrapServers.set(index, item); return (A)this;
  }
  
  public A addToBootstrapServers(java.lang.String... items) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
  }
  
  public A addAllToBootstrapServers(Collection<String> items) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
  }
  
  public A removeFromBootstrapServers(java.lang.String... items) {
    if (this.bootstrapServers == null) return (A)this;
    for (String item : items) { this.bootstrapServers.remove(item);} return (A)this;
  }
  
  public A removeAllFromBootstrapServers(Collection<String> items) {
    if (this.bootstrapServers == null) return (A)this;
    for (String item : items) { this.bootstrapServers.remove(item);} return (A)this;
  }
  
  public List<String> getBootstrapServers() {
    return this.bootstrapServers;
  }
  
  public String getBootstrapServer(int index) {
    return this.bootstrapServers.get(index);
  }
  
  public String getFirstBootstrapServer() {
    return this.bootstrapServers.get(0);
  }
  
  public String getLastBootstrapServer() {
    return this.bootstrapServers.get(bootstrapServers.size() - 1);
  }
  
  public String getMatchingBootstrapServer(Predicate<String> predicate) {
    for (String item: bootstrapServers) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
    for (String item: bootstrapServers) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withBootstrapServers(List<String> bootstrapServers) {
    if (bootstrapServers != null) {this.bootstrapServers = new ArrayList(); for (String item : bootstrapServers){this.addToBootstrapServers(item);}} else { this.bootstrapServers = null;} return (A) this;
  }
  
  public A withBootstrapServers(java.lang.String... bootstrapServers) {
    if (this.bootstrapServers != null) {this.bootstrapServers.clear(); _visitables.remove("bootstrapServers"); }
    if (bootstrapServers != null) {for (String item :bootstrapServers){ this.addToBootstrapServers(item);}} return (A) this;
  }
  
  public boolean hasBootstrapServers() {
    return bootstrapServers != null && !bootstrapServers.isEmpty();
  }
  
  public CloudEventOverrides buildCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  
  public A withCeOverrides(CloudEventOverrides ceOverrides) {
    _visitables.get("ceOverrides").remove(this.ceOverrides);
    if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} else { this.ceOverrides = null; _visitables.get("ceOverrides").remove(this.ceOverrides); } return (A) this;
  }
  
  public boolean hasCeOverrides() {
    return this.ceOverrides != null;
  }
  
  public CeOverridesNested<A> withNewCeOverrides() {
    return new CeOverridesNested(null);
  }
  
  public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
    return new CeOverridesNested(item);
  }
  
  public CeOverridesNested<A> editCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(null));
  }
  
  public CeOverridesNested<A> editOrNewCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
  }
  
  public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(item));
  }
  
  public String getConsumerGroup() {
    return this.consumerGroup;
  }
  
  public A withConsumerGroup(String consumerGroup) {
    this.consumerGroup=consumerGroup; return (A) this;
  }
  
  public boolean hasConsumerGroup() {
    return this.consumerGroup != null;
  }
  
  public Integer getConsumers() {
    return this.consumers;
  }
  
  public A withConsumers(Integer consumers) {
    this.consumers=consumers; return (A) this;
  }
  
  public boolean hasConsumers() {
    return this.consumers != null;
  }
  
  public DeliverySpec buildDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  
  public A withDelivery(DeliverySpec delivery) {
    _visitables.get("delivery").remove(this.delivery);
    if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} else { this.delivery = null; _visitables.get("delivery").remove(this.delivery); } return (A) this;
  }
  
  public boolean hasDelivery() {
    return this.delivery != null;
  }
  
  public DeliveryNested<A> withNewDelivery() {
    return new DeliveryNested(null);
  }
  
  public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new DeliveryNested(item);
  }
  
  public DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(null));
  }
  
  public DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(new DeliverySpecBuilder().build()));
  }
  
  public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(item));
  }
  
  public String getInitialOffset() {
    return this.initialOffset;
  }
  
  public A withInitialOffset(String initialOffset) {
    this.initialOffset=initialOffset; return (A) this;
  }
  
  public boolean hasInitialOffset() {
    return this.initialOffset != null;
  }
  
  public KafkaNetSpec buildNet() {
    return this.net!=null ?this.net.build():null;
  }
  
  public A withNet(KafkaNetSpec net) {
    _visitables.get("net").remove(this.net);
    if (net!=null){ this.net= new KafkaNetSpecBuilder(net); _visitables.get("net").add(this.net);} else { this.net = null; _visitables.get("net").remove(this.net); } return (A) this;
  }
  
  public boolean hasNet() {
    return this.net != null;
  }
  
  public NetNested<A> withNewNet() {
    return new NetNested(null);
  }
  
  public NetNested<A> withNewNetLike(KafkaNetSpec item) {
    return new NetNested(item);
  }
  
  public NetNested<A> editNet() {
    return withNewNetLike(java.util.Optional.ofNullable(buildNet()).orElse(null));
  }
  
  public NetNested<A> editOrNewNet() {
    return withNewNetLike(java.util.Optional.ofNullable(buildNet()).orElse(new KafkaNetSpecBuilder().build()));
  }
  
  public NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
    return withNewNetLike(java.util.Optional.ofNullable(buildNet()).orElse(item));
  }
  
  public Destination buildSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  
  public A withSink(Destination sink) {
    _visitables.get("sink").remove(this.sink);
    if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} else { this.sink = null; _visitables.get("sink").remove(this.sink); } return (A) this;
  }
  
  public boolean hasSink() {
    return this.sink != null;
  }
  
  public SinkNested<A> withNewSink() {
    return new SinkNested(null);
  }
  
  public SinkNested<A> withNewSinkLike(Destination item) {
    return new SinkNested(item);
  }
  
  public SinkNested<A> editSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(null));
  }
  
  public SinkNested<A> editOrNewSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(new DestinationBuilder().build()));
  }
  
  public SinkNested<A> editOrNewSinkLike(Destination item) {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(item));
  }
  
  public A addToTopics(int index,String item) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    this.topics.add(index, item);
    return (A)this;
  }
  
  public A setToTopics(int index,String item) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    this.topics.set(index, item); return (A)this;
  }
  
  public A addToTopics(java.lang.String... items) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    for (String item : items) {this.topics.add(item);} return (A)this;
  }
  
  public A addAllToTopics(Collection<String> items) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    for (String item : items) {this.topics.add(item);} return (A)this;
  }
  
  public A removeFromTopics(java.lang.String... items) {
    if (this.topics == null) return (A)this;
    for (String item : items) { this.topics.remove(item);} return (A)this;
  }
  
  public A removeAllFromTopics(Collection<String> items) {
    if (this.topics == null) return (A)this;
    for (String item : items) { this.topics.remove(item);} return (A)this;
  }
  
  public List<String> getTopics() {
    return this.topics;
  }
  
  public String getTopic(int index) {
    return this.topics.get(index);
  }
  
  public String getFirstTopic() {
    return this.topics.get(0);
  }
  
  public String getLastTopic() {
    return this.topics.get(topics.size() - 1);
  }
  
  public String getMatchingTopic(Predicate<String> predicate) {
    for (String item: topics) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingTopic(Predicate<String> predicate) {
    for (String item: topics) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withTopics(List<String> topics) {
    if (topics != null) {this.topics = new ArrayList(); for (String item : topics){this.addToTopics(item);}} else { this.topics = null;} return (A) this;
  }
  
  public A withTopics(java.lang.String... topics) {
    if (this.topics != null) {this.topics.clear(); _visitables.remove("topics"); }
    if (topics != null) {for (String item :topics){ this.addToTopics(item);}} return (A) this;
  }
  
  public boolean hasTopics() {
    return topics != null && !topics.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaSourceSpecFluent that = (KafkaSourceSpecFluent) o;
    if (!java.util.Objects.equals(bootstrapServers, that.bootstrapServers)) return false;
  
    if (!java.util.Objects.equals(ceOverrides, that.ceOverrides)) return false;
  
    if (!java.util.Objects.equals(consumerGroup, that.consumerGroup)) return false;
  
    if (!java.util.Objects.equals(consumers, that.consumers)) return false;
  
    if (!java.util.Objects.equals(delivery, that.delivery)) return false;
  
    if (!java.util.Objects.equals(initialOffset, that.initialOffset)) return false;
  
    if (!java.util.Objects.equals(net, that.net)) return false;
  
    if (!java.util.Objects.equals(sink, that.sink)) return false;
  
    if (!java.util.Objects.equals(topics, that.topics)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bootstrapServers,  ceOverrides,  consumerGroup,  consumers,  delivery,  initialOffset,  net,  sink,  topics,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapServers != null && !bootstrapServers.isEmpty()) { sb.append("bootstrapServers:"); sb.append(bootstrapServers + ","); }
    if (ceOverrides != null) { sb.append("ceOverrides:"); sb.append(ceOverrides + ","); }
    if (consumerGroup != null) { sb.append("consumerGroup:"); sb.append(consumerGroup + ","); }
    if (consumers != null) { sb.append("consumers:"); sb.append(consumers + ","); }
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (initialOffset != null) { sb.append("initialOffset:"); sb.append(initialOffset + ","); }
    if (net != null) { sb.append("net:"); sb.append(net + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink + ","); }
    if (topics != null && !topics.isEmpty()) { sb.append("topics:"); sb.append(topics); }
    sb.append("}");
    return sb.toString();
  }
  public class CeOverridesNested<N> extends CloudEventOverridesFluent<CeOverridesNested<N>> implements Nested<N>{
    CeOverridesNested(CloudEventOverrides item) {
      this.builder = new CloudEventOverridesBuilder(this, item);
    }
    CloudEventOverridesBuilder builder;
    
    public N and() {
      return (N) KafkaSourceSpecFluent.this.withCeOverrides(builder.build());
    }
    
    public N endCeOverrides() {
      return and();
    }
    
  
  }
  public class DeliveryNested<N> extends DeliverySpecFluent<DeliveryNested<N>> implements Nested<N>{
    DeliveryNested(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliverySpecBuilder builder;
    
    public N and() {
      return (N) KafkaSourceSpecFluent.this.withDelivery(builder.build());
    }
    
    public N endDelivery() {
      return and();
    }
    
  
  }
  public class NetNested<N> extends KafkaNetSpecFluent<NetNested<N>> implements Nested<N>{
    NetNested(KafkaNetSpec item) {
      this.builder = new KafkaNetSpecBuilder(this, item);
    }
    KafkaNetSpecBuilder builder;
    
    public N and() {
      return (N) KafkaSourceSpecFluent.this.withNet(builder.build());
    }
    
    public N endNet() {
      return and();
    }
    
  
  }
  public class SinkNested<N> extends DestinationFluent<SinkNested<N>> implements Nested<N>{
    SinkNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) KafkaSourceSpecFluent.this.withSink(builder.build());
    }
    
    public N endSink() {
      return and();
    }
    
  
  }

}