package io.fabric8.knative.eventing.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EventTypeBuilder extends EventTypeFluent<EventTypeBuilder> implements VisitableBuilder<EventType,EventTypeBuilder>{
  public EventTypeBuilder() {
    this(new EventType());
  }
  
  public EventTypeBuilder(EventTypeFluent<?> fluent) {
    this(fluent, new EventType());
  }
  
  public EventTypeBuilder(EventTypeFluent<?> fluent,EventType instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EventTypeBuilder(EventType instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EventTypeFluent<?> fluent;
  
  public EventType build() {
    EventType buildable = new EventType(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}