package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ParallelBranchFluent<A extends ParallelBranchFluent<A>> extends BaseFluent<A>{
  public ParallelBranchFluent() {
  }
  
  public ParallelBranchFluent(ParallelBranch instance) {
    this.copyInstance(instance);
  }
  private DeliverySpecBuilder delivery;
  private DestinationBuilder filter;
  private DestinationBuilder reply;
  private DestinationBuilder subscriber;
  
  protected void copyInstance(ParallelBranch instance) {
    instance = (instance != null ? instance : new ParallelBranch());
  
    if (instance != null) {
        this.withDelivery(instance.getDelivery());
        this.withFilter(instance.getFilter());
        this.withReply(instance.getReply());
        this.withSubscriber(instance.getSubscriber());
        this.withDelivery(instance.getDelivery());
        this.withFilter(instance.getFilter());
        this.withReply(instance.getReply());
        this.withSubscriber(instance.getSubscriber());
      }
  }
  
  public DeliverySpec buildDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  
  public A withDelivery(DeliverySpec delivery) {
    _visitables.get("delivery").remove(this.delivery);
    if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} else { this.delivery = null; _visitables.get("delivery").remove(this.delivery); } return (A) this;
  }
  
  public boolean hasDelivery() {
    return this.delivery != null;
  }
  
  public DeliveryNested<A> withNewDelivery() {
    return new DeliveryNested(null);
  }
  
  public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new DeliveryNested(item);
  }
  
  public DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(null));
  }
  
  public DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(new DeliverySpecBuilder().build()));
  }
  
  public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(item));
  }
  
  public Destination buildFilter() {
    return this.filter!=null ?this.filter.build():null;
  }
  
  public A withFilter(Destination filter) {
    _visitables.get("filter").remove(this.filter);
    if (filter!=null){ this.filter= new DestinationBuilder(filter); _visitables.get("filter").add(this.filter);} else { this.filter = null; _visitables.get("filter").remove(this.filter); } return (A) this;
  }
  
  public boolean hasFilter() {
    return this.filter != null;
  }
  
  public FilterNested<A> withNewFilter() {
    return new FilterNested(null);
  }
  
  public FilterNested<A> withNewFilterLike(Destination item) {
    return new FilterNested(item);
  }
  
  public FilterNested<A> editFilter() {
    return withNewFilterLike(java.util.Optional.ofNullable(buildFilter()).orElse(null));
  }
  
  public FilterNested<A> editOrNewFilter() {
    return withNewFilterLike(java.util.Optional.ofNullable(buildFilter()).orElse(new DestinationBuilder().build()));
  }
  
  public FilterNested<A> editOrNewFilterLike(Destination item) {
    return withNewFilterLike(java.util.Optional.ofNullable(buildFilter()).orElse(item));
  }
  
  public Destination buildReply() {
    return this.reply!=null ?this.reply.build():null;
  }
  
  public A withReply(Destination reply) {
    _visitables.get("reply").remove(this.reply);
    if (reply!=null){ this.reply= new DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} else { this.reply = null; _visitables.get("reply").remove(this.reply); } return (A) this;
  }
  
  public boolean hasReply() {
    return this.reply != null;
  }
  
  public ReplyNested<A> withNewReply() {
    return new ReplyNested(null);
  }
  
  public ReplyNested<A> withNewReplyLike(Destination item) {
    return new ReplyNested(item);
  }
  
  public ReplyNested<A> editReply() {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(null));
  }
  
  public ReplyNested<A> editOrNewReply() {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(new DestinationBuilder().build()));
  }
  
  public ReplyNested<A> editOrNewReplyLike(Destination item) {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(item));
  }
  
  public Destination buildSubscriber() {
    return this.subscriber!=null ?this.subscriber.build():null;
  }
  
  public A withSubscriber(Destination subscriber) {
    _visitables.get("subscriber").remove(this.subscriber);
    if (subscriber!=null){ this.subscriber= new DestinationBuilder(subscriber); _visitables.get("subscriber").add(this.subscriber);} else { this.subscriber = null; _visitables.get("subscriber").remove(this.subscriber); } return (A) this;
  }
  
  public boolean hasSubscriber() {
    return this.subscriber != null;
  }
  
  public SubscriberNested<A> withNewSubscriber() {
    return new SubscriberNested(null);
  }
  
  public SubscriberNested<A> withNewSubscriberLike(Destination item) {
    return new SubscriberNested(item);
  }
  
  public SubscriberNested<A> editSubscriber() {
    return withNewSubscriberLike(java.util.Optional.ofNullable(buildSubscriber()).orElse(null));
  }
  
  public SubscriberNested<A> editOrNewSubscriber() {
    return withNewSubscriberLike(java.util.Optional.ofNullable(buildSubscriber()).orElse(new DestinationBuilder().build()));
  }
  
  public SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
    return withNewSubscriberLike(java.util.Optional.ofNullable(buildSubscriber()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ParallelBranchFluent that = (ParallelBranchFluent) o;
    if (!java.util.Objects.equals(delivery, that.delivery)) return false;
  
    if (!java.util.Objects.equals(filter, that.filter)) return false;
  
    if (!java.util.Objects.equals(reply, that.reply)) return false;
  
    if (!java.util.Objects.equals(subscriber, that.subscriber)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(delivery,  filter,  reply,  subscriber,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (filter != null) { sb.append("filter:"); sb.append(filter + ","); }
    if (reply != null) { sb.append("reply:"); sb.append(reply + ","); }
    if (subscriber != null) { sb.append("subscriber:"); sb.append(subscriber); }
    sb.append("}");
    return sb.toString();
  }
  public class DeliveryNested<N> extends DeliverySpecFluent<DeliveryNested<N>> implements Nested<N>{
    DeliveryNested(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliverySpecBuilder builder;
    
    public N and() {
      return (N) ParallelBranchFluent.this.withDelivery(builder.build());
    }
    
    public N endDelivery() {
      return and();
    }
    
  
  }
  public class FilterNested<N> extends DestinationFluent<FilterNested<N>> implements Nested<N>{
    FilterNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) ParallelBranchFluent.this.withFilter(builder.build());
    }
    
    public N endFilter() {
      return and();
    }
    
  
  }
  public class ReplyNested<N> extends DestinationFluent<ReplyNested<N>> implements Nested<N>{
    ReplyNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) ParallelBranchFluent.this.withReply(builder.build());
    }
    
    public N endReply() {
      return and();
    }
    
  
  }
  public class SubscriberNested<N> extends DestinationFluent<SubscriberNested<N>> implements Nested<N>{
    SubscriberNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) ParallelBranchFluent.this.withSubscriber(builder.build());
    }
    
    public N endSubscriber() {
      return and();
    }
    
  
  }

}