package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SequenceStatusBuilder extends SequenceStatusFluent<SequenceStatusBuilder> implements VisitableBuilder<SequenceStatus,SequenceStatusBuilder>{
  public SequenceStatusBuilder() {
    this(new SequenceStatus());
  }
  
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent) {
    this(fluent, new SequenceStatus());
  }
  
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,SequenceStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SequenceStatusBuilder(SequenceStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SequenceStatusFluent<?> fluent;
  
  public SequenceStatus build() {
    SequenceStatus buildable = new SequenceStatus(fluent.buildAddress(),fluent.getAnnotations(),fluent.buildChannelStatuses(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.buildSubscriptionStatuses());
    return buildable;
  }
  

}