package io.fabric8.knative.internal.autoscaling.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MetricSpecFluent<A extends MetricSpecFluent<A>> extends BaseFluent<A>{
  public MetricSpecFluent() {
  }
  
  public MetricSpecFluent(MetricSpec instance) {
    this.copyInstance(instance);
  }
  private Long panicWindow;
  private String scrapeTarget;
  private Long stableWindow;
  
  protected void copyInstance(MetricSpec instance) {
    instance = (instance != null ? instance : new MetricSpec());
  
    if (instance != null) {
        this.withPanicWindow(instance.getPanicWindow());
        this.withScrapeTarget(instance.getScrapeTarget());
        this.withStableWindow(instance.getStableWindow());
        this.withPanicWindow(instance.getPanicWindow());
        this.withScrapeTarget(instance.getScrapeTarget());
        this.withStableWindow(instance.getStableWindow());
      }
  }
  
  public Long getPanicWindow() {
    return this.panicWindow;
  }
  
  public A withPanicWindow(Long panicWindow) {
    this.panicWindow=panicWindow; return (A) this;
  }
  
  public boolean hasPanicWindow() {
    return this.panicWindow != null;
  }
  
  public String getScrapeTarget() {
    return this.scrapeTarget;
  }
  
  public A withScrapeTarget(String scrapeTarget) {
    this.scrapeTarget=scrapeTarget; return (A) this;
  }
  
  public boolean hasScrapeTarget() {
    return this.scrapeTarget != null;
  }
  
  public Long getStableWindow() {
    return this.stableWindow;
  }
  
  public A withStableWindow(Long stableWindow) {
    this.stableWindow=stableWindow; return (A) this;
  }
  
  public boolean hasStableWindow() {
    return this.stableWindow != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetricSpecFluent that = (MetricSpecFluent) o;
    if (!java.util.Objects.equals(panicWindow, that.panicWindow)) return false;
  
    if (!java.util.Objects.equals(scrapeTarget, that.scrapeTarget)) return false;
  
    if (!java.util.Objects.equals(stableWindow, that.stableWindow)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(panicWindow,  scrapeTarget,  stableWindow,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (panicWindow != null) { sb.append("panicWindow:"); sb.append(panicWindow + ","); }
    if (scrapeTarget != null) { sb.append("scrapeTarget:"); sb.append(scrapeTarget + ","); }
    if (stableWindow != null) { sb.append("stableWindow:"); sb.append(stableWindow); }
    sb.append("}");
    return sb.toString();
  }
  

}