package io.fabric8.knative.internal.autoscaling.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodAutoscalerStatusBuilder extends PodAutoscalerStatusFluent<PodAutoscalerStatusBuilder> implements VisitableBuilder<PodAutoscalerStatus,PodAutoscalerStatusBuilder>{
  public PodAutoscalerStatusBuilder() {
    this(new PodAutoscalerStatus());
  }
  
  public PodAutoscalerStatusBuilder(PodAutoscalerStatusFluent<?> fluent) {
    this(fluent, new PodAutoscalerStatus());
  }
  
  public PodAutoscalerStatusBuilder(PodAutoscalerStatusFluent<?> fluent,PodAutoscalerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodAutoscalerStatusBuilder(PodAutoscalerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodAutoscalerStatusFluent<?> fluent;
  
  public PodAutoscalerStatus build() {
    PodAutoscalerStatus buildable = new PodAutoscalerStatus(fluent.getActualScale(),fluent.getAnnotations(),fluent.buildConditions(),fluent.getDesiredScale(),fluent.getMetricsServiceName(),fluent.getObservedGeneration(),fluent.getServiceName());
    return buildable;
  }
  

}