package io.fabric8.knative.internal.caching.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageSpecBuilder extends ImageSpecFluent<ImageSpecBuilder> implements VisitableBuilder<ImageSpec,ImageSpecBuilder>{
  public ImageSpecBuilder() {
    this(new ImageSpec());
  }
  
  public ImageSpecBuilder(ImageSpecFluent<?> fluent) {
    this(fluent, new ImageSpec());
  }
  
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,ImageSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageSpecBuilder(ImageSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageSpecFluent<?> fluent;
  
  public ImageSpec build() {
    ImageSpec buildable = new ImageSpec(fluent.getImage(),fluent.buildImagePullSecrets(),fluent.getServiceAccountName());
    return buildable;
  }
  

}