package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPIngressPathFluent<A extends HTTPIngressPathFluent<A>> extends BaseFluent<A>{
  public HTTPIngressPathFluent() {
  }
  
  public HTTPIngressPathFluent(HTTPIngressPath instance) {
    this.copyInstance(instance);
  }
  private Map<String,String> appendHeaders;
  private Map<String,HeaderMatch> headers;
  private String path;
  private String rewriteHost;
  private ArrayList<IngressBackendSplitBuilder> splits = new ArrayList<IngressBackendSplitBuilder>();
  
  protected void copyInstance(HTTPIngressPath instance) {
    instance = (instance != null ? instance : new HTTPIngressPath());
  
    if (instance != null) {
        this.withAppendHeaders(instance.getAppendHeaders());
        this.withHeaders(instance.getHeaders());
        this.withPath(instance.getPath());
        this.withRewriteHost(instance.getRewriteHost());
        this.withSplits(instance.getSplits());
        this.withAppendHeaders(instance.getAppendHeaders());
        this.withHeaders(instance.getHeaders());
        this.withPath(instance.getPath());
        this.withRewriteHost(instance.getRewriteHost());
        this.withSplits(instance.getSplits());
      }
  }
  
  public A addToAppendHeaders(String key,String value) {
    if(this.appendHeaders == null && key != null && value != null) { this.appendHeaders = new LinkedHashMap(); }
    if(key != null && value != null) {this.appendHeaders.put(key, value);} return (A)this;
  }
  
  public A addToAppendHeaders(Map<String,String> map) {
    if(this.appendHeaders == null && map != null) { this.appendHeaders = new LinkedHashMap(); }
    if(map != null) { this.appendHeaders.putAll(map);} return (A)this;
  }
  
  public A removeFromAppendHeaders(String key) {
    if(this.appendHeaders == null) { return (A) this; }
    if(key != null && this.appendHeaders != null) {this.appendHeaders.remove(key);} return (A)this;
  }
  
  public A removeFromAppendHeaders(Map<String,String> map) {
    if(this.appendHeaders == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.appendHeaders != null){this.appendHeaders.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getAppendHeaders() {
    return this.appendHeaders;
  }
  
  public <K,V>A withAppendHeaders(Map<String,String> appendHeaders) {
    if (appendHeaders == null) { this.appendHeaders =  null;} else {this.appendHeaders = new LinkedHashMap(appendHeaders);} return (A) this;
  }
  
  public boolean hasAppendHeaders() {
    return this.appendHeaders != null;
  }
  
  public A addToHeaders(String key,HeaderMatch value) {
    if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap(); }
    if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
  }
  
  public A addToHeaders(Map<String,HeaderMatch> map) {
    if(this.headers == null && map != null) { this.headers = new LinkedHashMap(); }
    if(map != null) { this.headers.putAll(map);} return (A)this;
  }
  
  public A removeFromHeaders(String key) {
    if(this.headers == null) { return (A) this; }
    if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
  }
  
  public A removeFromHeaders(Map<String,HeaderMatch> map) {
    if(this.headers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
  }
  
  public Map<String,HeaderMatch> getHeaders() {
    return this.headers;
  }
  
  public <K,V>A withHeaders(Map<String,HeaderMatch> headers) {
    if (headers == null) { this.headers =  null;} else {this.headers = new LinkedHashMap(headers);} return (A) this;
  }
  
  public boolean hasHeaders() {
    return this.headers != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public String getRewriteHost() {
    return this.rewriteHost;
  }
  
  public A withRewriteHost(String rewriteHost) {
    this.rewriteHost=rewriteHost; return (A) this;
  }
  
  public boolean hasRewriteHost() {
    return this.rewriteHost != null;
  }
  
  public A addToSplits(int index,IngressBackendSplit item) {
    if (this.splits == null) {this.splits = new ArrayList<IngressBackendSplitBuilder>();}
    IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);
    if (index < 0 || index >= splits.size()) { _visitables.get("splits").add(builder); splits.add(builder); } else { _visitables.get("splits").add(index, builder); splits.add(index, builder);}
    return (A)this;
  }
  
  public A setToSplits(int index,IngressBackendSplit item) {
    if (this.splits == null) {this.splits = new ArrayList<IngressBackendSplitBuilder>();}
    IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);
    if (index < 0 || index >= splits.size()) { _visitables.get("splits").add(builder); splits.add(builder); } else { _visitables.get("splits").set(index, builder); splits.set(index, builder);}
    return (A)this;
  }
  
  public A addToSplits(io.fabric8.knative.internal.networking.v1alpha1.IngressBackendSplit... items) {
    if (this.splits == null) {this.splits = new ArrayList<IngressBackendSplitBuilder>();}
    for (IngressBackendSplit item : items) {IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);_visitables.get("splits").add(builder);this.splits.add(builder);} return (A)this;
  }
  
  public A addAllToSplits(Collection<IngressBackendSplit> items) {
    if (this.splits == null) {this.splits = new ArrayList<IngressBackendSplitBuilder>();}
    for (IngressBackendSplit item : items) {IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);_visitables.get("splits").add(builder);this.splits.add(builder);} return (A)this;
  }
  
  public A removeFromSplits(io.fabric8.knative.internal.networking.v1alpha1.IngressBackendSplit... items) {
    if (this.splits == null) return (A)this;
    for (IngressBackendSplit item : items) {IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);_visitables.get("splits").remove(builder); this.splits.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSplits(Collection<IngressBackendSplit> items) {
    if (this.splits == null) return (A)this;
    for (IngressBackendSplit item : items) {IngressBackendSplitBuilder builder = new IngressBackendSplitBuilder(item);_visitables.get("splits").remove(builder); this.splits.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSplits(Predicate<IngressBackendSplitBuilder> predicate) {
    if (splits == null) return (A) this;
    final Iterator<IngressBackendSplitBuilder> each = splits.iterator();
    final List visitables = _visitables.get("splits");
    while (each.hasNext()) {
      IngressBackendSplitBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<IngressBackendSplit> buildSplits() {
    return splits != null ? build(splits) : null;
  }
  
  public IngressBackendSplit buildSplit(int index) {
    return this.splits.get(index).build();
  }
  
  public IngressBackendSplit buildFirstSplit() {
    return this.splits.get(0).build();
  }
  
  public IngressBackendSplit buildLastSplit() {
    return this.splits.get(splits.size() - 1).build();
  }
  
  public IngressBackendSplit buildMatchingSplit(Predicate<IngressBackendSplitBuilder> predicate) {
    for (IngressBackendSplitBuilder item: splits) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingSplit(Predicate<IngressBackendSplitBuilder> predicate) {
    for (IngressBackendSplitBuilder item: splits) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withSplits(List<IngressBackendSplit> splits) {
    if (this.splits != null) { _visitables.get("splits").clear();}
    if (splits != null) {this.splits = new ArrayList(); for (IngressBackendSplit item : splits){this.addToSplits(item);}} else { this.splits = null;} return (A) this;
  }
  
  public A withSplits(io.fabric8.knative.internal.networking.v1alpha1.IngressBackendSplit... splits) {
    if (this.splits != null) {this.splits.clear(); _visitables.remove("splits"); }
    if (splits != null) {for (IngressBackendSplit item :splits){ this.addToSplits(item);}} return (A) this;
  }
  
  public boolean hasSplits() {
    return splits != null && !splits.isEmpty();
  }
  
  public SplitsNested<A> addNewSplit() {
    return new SplitsNested(-1, null);
  }
  
  public SplitsNested<A> addNewSplitLike(IngressBackendSplit item) {
    return new SplitsNested(-1, item);
  }
  
  public SplitsNested<A> setNewSplitLike(int index,IngressBackendSplit item) {
    return new SplitsNested(index, item);
  }
  
  public SplitsNested<A> editSplit(int index) {
    if (splits.size() <= index) throw new RuntimeException("Can't edit splits. Index exceeds size.");
    return setNewSplitLike(index, buildSplit(index));
  }
  
  public SplitsNested<A> editFirstSplit() {
    if (splits.size() == 0) throw new RuntimeException("Can't edit first splits. The list is empty.");
    return setNewSplitLike(0, buildSplit(0));
  }
  
  public SplitsNested<A> editLastSplit() {
    int index = splits.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last splits. The list is empty.");
    return setNewSplitLike(index, buildSplit(index));
  }
  
  public SplitsNested<A> editMatchingSplit(Predicate<IngressBackendSplitBuilder> predicate) {
    int index = -1;
    for (int i=0;i<splits.size();i++) { 
    if (predicate.test(splits.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching splits. No match found.");
    return setNewSplitLike(index, buildSplit(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPIngressPathFluent that = (HTTPIngressPathFluent) o;
    if (!java.util.Objects.equals(appendHeaders, that.appendHeaders)) return false;
  
    if (!java.util.Objects.equals(headers, that.headers)) return false;
  
    if (!java.util.Objects.equals(path, that.path)) return false;
  
    if (!java.util.Objects.equals(rewriteHost, that.rewriteHost)) return false;
  
    if (!java.util.Objects.equals(splits, that.splits)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(appendHeaders,  headers,  path,  rewriteHost,  splits,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (appendHeaders != null && !appendHeaders.isEmpty()) { sb.append("appendHeaders:"); sb.append(appendHeaders + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (rewriteHost != null) { sb.append("rewriteHost:"); sb.append(rewriteHost + ","); }
    if (splits != null && !splits.isEmpty()) { sb.append("splits:"); sb.append(splits); }
    sb.append("}");
    return sb.toString();
  }
  public class SplitsNested<N> extends IngressBackendSplitFluent<SplitsNested<N>> implements Nested<N>{
    SplitsNested(int index,IngressBackendSplit item) {
      this.index = index;
      this.builder = new IngressBackendSplitBuilder(this, item);
    }
    IngressBackendSplitBuilder builder;
    int index;
    
    public N and() {
      return (N) HTTPIngressPathFluent.this.setToSplits(index,builder.build());
    }
    
    public N endSplit() {
      return and();
    }
    
  
  }

}