package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressBackendSplitFluent<A extends IngressBackendSplitFluent<A>> extends BaseFluent<A>{
  public IngressBackendSplitFluent() {
  }
  
  public IngressBackendSplitFluent(IngressBackendSplit instance) {
    this.copyInstance(instance);
  }
  private Map<String,String> appendHeaders;
  private Integer percent;
  private String serviceName;
  private String serviceNamespace;
  private IntOrStringBuilder servicePort;
  
  protected void copyInstance(IngressBackendSplit instance) {
    instance = (instance != null ? instance : new IngressBackendSplit());
  
    if (instance != null) {
        this.withAppendHeaders(instance.getAppendHeaders());
        this.withPercent(instance.getPercent());
        this.withServiceName(instance.getServiceName());
        this.withServiceNamespace(instance.getServiceNamespace());
        this.withServicePort(instance.getServicePort());
        this.withAppendHeaders(instance.getAppendHeaders());
        this.withPercent(instance.getPercent());
        this.withServiceName(instance.getServiceName());
        this.withServiceNamespace(instance.getServiceNamespace());
        this.withServicePort(instance.getServicePort());
      }
  }
  
  public A addToAppendHeaders(String key,String value) {
    if(this.appendHeaders == null && key != null && value != null) { this.appendHeaders = new LinkedHashMap(); }
    if(key != null && value != null) {this.appendHeaders.put(key, value);} return (A)this;
  }
  
  public A addToAppendHeaders(Map<String,String> map) {
    if(this.appendHeaders == null && map != null) { this.appendHeaders = new LinkedHashMap(); }
    if(map != null) { this.appendHeaders.putAll(map);} return (A)this;
  }
  
  public A removeFromAppendHeaders(String key) {
    if(this.appendHeaders == null) { return (A) this; }
    if(key != null && this.appendHeaders != null) {this.appendHeaders.remove(key);} return (A)this;
  }
  
  public A removeFromAppendHeaders(Map<String,String> map) {
    if(this.appendHeaders == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.appendHeaders != null){this.appendHeaders.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getAppendHeaders() {
    return this.appendHeaders;
  }
  
  public <K,V>A withAppendHeaders(Map<String,String> appendHeaders) {
    if (appendHeaders == null) { this.appendHeaders =  null;} else {this.appendHeaders = new LinkedHashMap(appendHeaders);} return (A) this;
  }
  
  public boolean hasAppendHeaders() {
    return this.appendHeaders != null;
  }
  
  public Integer getPercent() {
    return this.percent;
  }
  
  public A withPercent(Integer percent) {
    this.percent=percent; return (A) this;
  }
  
  public boolean hasPercent() {
    return this.percent != null;
  }
  
  public String getServiceName() {
    return this.serviceName;
  }
  
  public A withServiceName(String serviceName) {
    this.serviceName=serviceName; return (A) this;
  }
  
  public boolean hasServiceName() {
    return this.serviceName != null;
  }
  
  public String getServiceNamespace() {
    return this.serviceNamespace;
  }
  
  public A withServiceNamespace(String serviceNamespace) {
    this.serviceNamespace=serviceNamespace; return (A) this;
  }
  
  public boolean hasServiceNamespace() {
    return this.serviceNamespace != null;
  }
  
  public IntOrString buildServicePort() {
    return this.servicePort!=null ?this.servicePort.build():null;
  }
  
  public A withServicePort(IntOrString servicePort) {
    _visitables.get("servicePort").remove(this.servicePort);
    if (servicePort!=null){ this.servicePort= new IntOrStringBuilder(servicePort); _visitables.get("servicePort").add(this.servicePort);} else { this.servicePort = null; _visitables.get("servicePort").remove(this.servicePort); } return (A) this;
  }
  
  public boolean hasServicePort() {
    return this.servicePort != null;
  }
  
  public A withNewServicePort(Object value) {
    return (A)withServicePort(new IntOrString(value));
  }
  
  public ServicePortNested<A> withNewServicePort() {
    return new ServicePortNested(null);
  }
  
  public ServicePortNested<A> withNewServicePortLike(IntOrString item) {
    return new ServicePortNested(item);
  }
  
  public ServicePortNested<A> editServicePort() {
    return withNewServicePortLike(java.util.Optional.ofNullable(buildServicePort()).orElse(null));
  }
  
  public ServicePortNested<A> editOrNewServicePort() {
    return withNewServicePortLike(java.util.Optional.ofNullable(buildServicePort()).orElse(new IntOrStringBuilder().build()));
  }
  
  public ServicePortNested<A> editOrNewServicePortLike(IntOrString item) {
    return withNewServicePortLike(java.util.Optional.ofNullable(buildServicePort()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressBackendSplitFluent that = (IngressBackendSplitFluent) o;
    if (!java.util.Objects.equals(appendHeaders, that.appendHeaders)) return false;
  
    if (!java.util.Objects.equals(percent, that.percent)) return false;
  
    if (!java.util.Objects.equals(serviceName, that.serviceName)) return false;
  
    if (!java.util.Objects.equals(serviceNamespace, that.serviceNamespace)) return false;
  
    if (!java.util.Objects.equals(servicePort, that.servicePort)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(appendHeaders,  percent,  serviceName,  serviceNamespace,  servicePort,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (appendHeaders != null && !appendHeaders.isEmpty()) { sb.append("appendHeaders:"); sb.append(appendHeaders + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (serviceName != null) { sb.append("serviceName:"); sb.append(serviceName + ","); }
    if (serviceNamespace != null) { sb.append("serviceNamespace:"); sb.append(serviceNamespace + ","); }
    if (servicePort != null) { sb.append("servicePort:"); sb.append(servicePort); }
    sb.append("}");
    return sb.toString();
  }
  public class ServicePortNested<N> extends IntOrStringFluent<ServicePortNested<N>> implements Nested<N>{
    ServicePortNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) IngressBackendSplitFluent.this.withServicePort(builder.build());
    }
    
    public N endServicePort() {
      return and();
    }
    
  
  }

}