package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressBuilder extends IngressFluent<IngressBuilder> implements VisitableBuilder<Ingress,IngressBuilder>{
  public IngressBuilder() {
    this(new Ingress());
  }
  
  public IngressBuilder(IngressFluent<?> fluent) {
    this(fluent, new Ingress());
  }
  
  public IngressBuilder(IngressFluent<?> fluent,Ingress instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressBuilder(Ingress instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressFluent<?> fluent;
  
  public Ingress build() {
    Ingress buildable = new Ingress(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}