package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressRuleBuilder extends IngressRuleFluent<IngressRuleBuilder> implements VisitableBuilder<IngressRule,IngressRuleBuilder>{
  public IngressRuleBuilder() {
    this(new IngressRule());
  }
  
  public IngressRuleBuilder(IngressRuleFluent<?> fluent) {
    this(fluent, new IngressRule());
  }
  
  public IngressRuleBuilder(IngressRuleFluent<?> fluent,IngressRule instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressRuleBuilder(IngressRule instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressRuleFluent<?> fluent;
  
  public IngressRule build() {
    IngressRule buildable = new IngressRule(fluent.getHosts(),fluent.buildHttp(),fluent.getVisibility());
    return buildable;
  }
  

}