package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressStatusBuilder extends IngressStatusFluent<IngressStatusBuilder> implements VisitableBuilder<IngressStatus,IngressStatusBuilder>{
  public IngressStatusBuilder() {
    this(new IngressStatus());
  }
  
  public IngressStatusBuilder(IngressStatusFluent<?> fluent) {
    this(fluent, new IngressStatus());
  }
  
  public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressStatusBuilder(IngressStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressStatusFluent<?> fluent;
  
  public IngressStatus build() {
    IngressStatus buildable = new IngressStatus(fluent.getAnnotations(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.buildPrivateLoadBalancer(),fluent.buildPublicLoadBalancer());
    return buildable;
  }
  

}