package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LoadBalancerStatusFluent<A extends LoadBalancerStatusFluent<A>> extends BaseFluent<A>{
  public LoadBalancerStatusFluent() {
  }
  
  public LoadBalancerStatusFluent(LoadBalancerStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<LoadBalancerIngressStatusBuilder> ingress = new ArrayList<LoadBalancerIngressStatusBuilder>();
  
  protected void copyInstance(LoadBalancerStatus instance) {
    instance = (instance != null ? instance : new LoadBalancerStatus());
  
    if (instance != null) {
        this.withIngress(instance.getIngress());
        this.withIngress(instance.getIngress());
      }
  }
  
  public A addToIngress(int index,LoadBalancerIngressStatus item) {
    if (this.ingress == null) {this.ingress = new ArrayList<LoadBalancerIngressStatusBuilder>();}
    LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);
    if (index < 0 || index >= ingress.size()) { _visitables.get("ingress").add(builder); ingress.add(builder); } else { _visitables.get("ingress").add(index, builder); ingress.add(index, builder);}
    return (A)this;
  }
  
  public A setToIngress(int index,LoadBalancerIngressStatus item) {
    if (this.ingress == null) {this.ingress = new ArrayList<LoadBalancerIngressStatusBuilder>();}
    LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);
    if (index < 0 || index >= ingress.size()) { _visitables.get("ingress").add(builder); ingress.add(builder); } else { _visitables.get("ingress").set(index, builder); ingress.set(index, builder);}
    return (A)this;
  }
  
  public A addToIngress(io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerIngressStatus... items) {
    if (this.ingress == null) {this.ingress = new ArrayList<LoadBalancerIngressStatusBuilder>();}
    for (LoadBalancerIngressStatus item : items) {LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  
  public A addAllToIngress(Collection<LoadBalancerIngressStatus> items) {
    if (this.ingress == null) {this.ingress = new ArrayList<LoadBalancerIngressStatusBuilder>();}
    for (LoadBalancerIngressStatus item : items) {LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  
  public A removeFromIngress(io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerIngressStatus... items) {
    if (this.ingress == null) return (A)this;
    for (LoadBalancerIngressStatus item : items) {LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);_visitables.get("ingress").remove(builder); this.ingress.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIngress(Collection<LoadBalancerIngressStatus> items) {
    if (this.ingress == null) return (A)this;
    for (LoadBalancerIngressStatus item : items) {LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);_visitables.get("ingress").remove(builder); this.ingress.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIngress(Predicate<LoadBalancerIngressStatusBuilder> predicate) {
    if (ingress == null) return (A) this;
    final Iterator<LoadBalancerIngressStatusBuilder> each = ingress.iterator();
    final List visitables = _visitables.get("ingress");
    while (each.hasNext()) {
      LoadBalancerIngressStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LoadBalancerIngressStatus> buildIngress() {
    return ingress != null ? build(ingress) : null;
  }
  
  public LoadBalancerIngressStatus buildIngress(int index) {
    return this.ingress.get(index).build();
  }
  
  public LoadBalancerIngressStatus buildFirstIngress() {
    return this.ingress.get(0).build();
  }
  
  public LoadBalancerIngressStatus buildLastIngress() {
    return this.ingress.get(ingress.size() - 1).build();
  }
  
  public LoadBalancerIngressStatus buildMatchingIngress(Predicate<LoadBalancerIngressStatusBuilder> predicate) {
    for (LoadBalancerIngressStatusBuilder item: ingress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingIngress(Predicate<LoadBalancerIngressStatusBuilder> predicate) {
    for (LoadBalancerIngressStatusBuilder item: ingress) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withIngress(List<LoadBalancerIngressStatus> ingress) {
    if (this.ingress != null) { _visitables.get("ingress").clear();}
    if (ingress != null) {this.ingress = new ArrayList(); for (LoadBalancerIngressStatus item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
  }
  
  public A withIngress(io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerIngressStatus... ingress) {
    if (this.ingress != null) {this.ingress.clear(); _visitables.remove("ingress"); }
    if (ingress != null) {for (LoadBalancerIngressStatus item :ingress){ this.addToIngress(item);}} return (A) this;
  }
  
  public boolean hasIngress() {
    return ingress != null && !ingress.isEmpty();
  }
  
  public A addNewIngress(String domain,String domainInternal,String ip,Boolean meshOnly) {
    return (A)addToIngress(new LoadBalancerIngressStatus(domain, domainInternal, ip, meshOnly));
  }
  
  public IngressNested<A> addNewIngress() {
    return new IngressNested(-1, null);
  }
  
  public IngressNested<A> addNewIngressLike(LoadBalancerIngressStatus item) {
    return new IngressNested(-1, item);
  }
  
  public IngressNested<A> setNewIngressLike(int index,LoadBalancerIngressStatus item) {
    return new IngressNested(index, item);
  }
  
  public IngressNested<A> editIngress(int index) {
    if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public IngressNested<A> editFirstIngress() {
    if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
    return setNewIngressLike(0, buildIngress(0));
  }
  
  public IngressNested<A> editLastIngress() {
    int index = ingress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public IngressNested<A> editMatchingIngress(Predicate<LoadBalancerIngressStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ingress.size();i++) { 
    if (predicate.test(ingress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LoadBalancerStatusFluent that = (LoadBalancerStatusFluent) o;
    if (!java.util.Objects.equals(ingress, that.ingress)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ingress,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ingress != null && !ingress.isEmpty()) { sb.append("ingress:"); sb.append(ingress); }
    sb.append("}");
    return sb.toString();
  }
  public class IngressNested<N> extends LoadBalancerIngressStatusFluent<IngressNested<N>> implements Nested<N>{
    IngressNested(int index,LoadBalancerIngressStatus item) {
      this.index = index;
      this.builder = new LoadBalancerIngressStatusBuilder(this, item);
    }
    LoadBalancerIngressStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) LoadBalancerStatusFluent.this.setToIngress(index,builder.build());
    }
    
    public N endIngress() {
      return and();
    }
    
  
  }

}