package io.fabric8.knative.internal.networking.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServerlessServiceSpecFluent<A extends ServerlessServiceSpecFluent<A>> extends BaseFluent<A>{
  public ServerlessServiceSpecFluent() {
  }
  
  public ServerlessServiceSpecFluent(ServerlessServiceSpec instance) {
    this.copyInstance(instance);
  }
  private String mode;
  private Integer numActivators;
  private ObjectReferenceBuilder objectRef;
  private String protocolType;
  
  protected void copyInstance(ServerlessServiceSpec instance) {
    instance = (instance != null ? instance : new ServerlessServiceSpec());
  
    if (instance != null) {
        this.withMode(instance.getMode());
        this.withNumActivators(instance.getNumActivators());
        this.withObjectRef(instance.getObjectRef());
        this.withProtocolType(instance.getProtocolType());
        this.withMode(instance.getMode());
        this.withNumActivators(instance.getNumActivators());
        this.withObjectRef(instance.getObjectRef());
        this.withProtocolType(instance.getProtocolType());
      }
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public Integer getNumActivators() {
    return this.numActivators;
  }
  
  public A withNumActivators(Integer numActivators) {
    this.numActivators=numActivators; return (A) this;
  }
  
  public boolean hasNumActivators() {
    return this.numActivators != null;
  }
  
  public ObjectReference buildObjectRef() {
    return this.objectRef!=null ?this.objectRef.build():null;
  }
  
  public A withObjectRef(ObjectReference objectRef) {
    _visitables.get("objectRef").remove(this.objectRef);
    if (objectRef!=null){ this.objectRef= new ObjectReferenceBuilder(objectRef); _visitables.get("objectRef").add(this.objectRef);} else { this.objectRef = null; _visitables.get("objectRef").remove(this.objectRef); } return (A) this;
  }
  
  public boolean hasObjectRef() {
    return this.objectRef != null;
  }
  
  public ObjectRefNested<A> withNewObjectRef() {
    return new ObjectRefNested(null);
  }
  
  public ObjectRefNested<A> withNewObjectRefLike(ObjectReference item) {
    return new ObjectRefNested(item);
  }
  
  public ObjectRefNested<A> editObjectRef() {
    return withNewObjectRefLike(java.util.Optional.ofNullable(buildObjectRef()).orElse(null));
  }
  
  public ObjectRefNested<A> editOrNewObjectRef() {
    return withNewObjectRefLike(java.util.Optional.ofNullable(buildObjectRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ObjectRefNested<A> editOrNewObjectRefLike(ObjectReference item) {
    return withNewObjectRefLike(java.util.Optional.ofNullable(buildObjectRef()).orElse(item));
  }
  
  public String getProtocolType() {
    return this.protocolType;
  }
  
  public A withProtocolType(String protocolType) {
    this.protocolType=protocolType; return (A) this;
  }
  
  public boolean hasProtocolType() {
    return this.protocolType != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServerlessServiceSpecFluent that = (ServerlessServiceSpecFluent) o;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
  
    if (!java.util.Objects.equals(numActivators, that.numActivators)) return false;
  
    if (!java.util.Objects.equals(objectRef, that.objectRef)) return false;
  
    if (!java.util.Objects.equals(protocolType, that.protocolType)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mode,  numActivators,  objectRef,  protocolType,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (numActivators != null) { sb.append("numActivators:"); sb.append(numActivators + ","); }
    if (objectRef != null) { sb.append("objectRef:"); sb.append(objectRef + ","); }
    if (protocolType != null) { sb.append("protocolType:"); sb.append(protocolType); }
    sb.append("}");
    return sb.toString();
  }
  public class ObjectRefNested<N> extends ObjectReferenceFluent<ObjectRefNested<N>> implements Nested<N>{
    ObjectRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ServerlessServiceSpecFluent.this.withObjectRef(builder.build());
    }
    
    public N endObjectRef() {
      return and();
    }
    
  
  }

}