package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KReferenceBuilder extends KReferenceFluent<KReferenceBuilder> implements VisitableBuilder<KReference,KReferenceBuilder>{
  public KReferenceBuilder() {
    this(new KReference());
  }
  
  public KReferenceBuilder(KReferenceFluent<?> fluent) {
    this(fluent, new KReference());
  }
  
  public KReferenceBuilder(KReferenceFluent<?> fluent,KReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KReferenceBuilder(KReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KReferenceFluent<?> fluent;
  
  public KReference build() {
    KReference buildable = new KReference(fluent.getAddress(),fluent.getApiVersion(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
    return buildable;
  }
  

}